#include "gringo-init.h"

TCheckBox* checkbox_Create( TWindow* win, int x, int y, char *title, int checked ) {
  TCheckBox *obj;
  // Check parameters
  assert( win != NULL );
  assert( win->object.type == TYPE_WINDOW );
  assert( x>=0 );
  assert( y>=0 );
  assert( title != NULL );
  // Create object
  obj = calloc( 1, sizeof(TCheckBox) );
  assert( obj != NULL );
  // Initialize basic object
  obj->object.name = NULL;
  obj->object.type = TYPE_CHECKBOX;
  obj->object.x = x;
  obj->object.y = y;
  obj->object.w = strlen(title) + 4; 
  obj->object.h = 1;
  obj->object.active = FALSE;
  obj->object.enabled = TRUE;
  obj->object.visible = TRUE;
  obj->object.parent = NULL;
  // Add the object to the double-linked list of widgets of this window
  window_AttachObject( win, obj );
  if (gringo_Mode == NCURSES_MODE ) {
    #ifdef USES_NCURSES
    // Set Tcheckbox fields
    obj->status  = checked;
    obj->caption = (char*) strdup(title);
    obj->caption_color = COLOR_PAIR( COLOR_BLACK_WHITE );
    obj->caption_color_active = A_BOLD | COLOR_PAIR( COLOR_YELLOW_BLUE );
    // Now create the checkbox
    obj->window = derwin(win->window, obj->object.h, obj->object.w, obj->object.y, obj->object.x);
    assert( obj->window != NULL );
    keypad (obj->window, TRUE);
    scrollok (obj->window, FALSE);
    #endif
  } else
  if (gringo_Mode == GTK_MODE ) {
    #ifdef USES_GTK
    obj->widget = gtk_check_button_new_with_label( (char*)title );
    assert(obj->widget);
    gtk_widget_set_usize( GTK_WIDGET(obj->widget), obj->object.w * XFACTOR, 1 * YFACTOR );
    gtk_fixed_put( GTK_FIXED(win->fixed), obj->widget, obj->object.x * XFACTOR, obj->object.y * YFACTOR );
    gtk_widget_show( GTK_WIDGET(obj->widget) );
    #endif
  }
  return obj;
}
