#include "gringo-init.h"

void button_Paint( TButton* obj ) {
#ifdef USES_NCURSES
  int i, l1, l2;
  int isActive;
#endif    
  assert( obj != NULL );
  assert( obj->object.type == TYPE_BUTTON );
  if ( obj->object.visible == FALSE ) return;

  if (gringo_Mode == NCURSES_MODE ) {
    #ifdef USES_NCURSES
    isActive = ( obj->object.active ==TRUE ) &&( obj->object.enabled ==TRUE ) && ( obj->object.parent == gringo_ActiveWindow );
    // Draw
    werase(obj->window);
    wmove(obj->window,0,0);
    wattrset( obj->window, isActive ? obj->caption_color_active : obj->caption_color );
    waddstr ( obj->window, isActive ? "[" : "<" );
    // Title
    if (obj->caption == NULL) {
      i=0; 
    } else {
      i=strlen( obj->caption );
    }
    i = (obj->object.w) - 2 - i;
    l1 = i / 2;
    l2 = i - l1;
    for ( i=0; i<l1; i++ ) waddch(obj->window,32);
    if (obj->caption != NULL ) waddstr(obj->window,obj->caption);
    for ( i=0; i<l2; i++ ) waddch(obj->window,32);
    waddstr ( obj->window, isActive ? "]" : ">" );
    wmove ( obj->window, 1, obj->object.w / 2 );
    wnoutrefresh (obj->window);
    #endif
  } else
  if (gringo_Mode == GTK_MODE ) {
    #ifdef USES_GTK
    gtk_widget_show( GTK_WIDGET(obj->widget) );
    #endif
  }
}
