#include "gringo-init.h"

#ifdef USES_GTK
void button_SetStatus(GtkWidget *widget, gpointer data) {
  TBUTTON(data) -> status = 1;
}
#endif


TButton* button_Create( TWindow* win, int x, int y, int w, char *title ) {
  TButton *obj;
  // Check parameters
  assert( win != NULL );
  assert( win->object.type == TYPE_WINDOW );
  assert( x>=0 );
  assert( y>=0 );
  assert( w>=0 );
  assert( title != NULL );
  // Create object
  obj = calloc( 1, sizeof(TButton) );
  assert( obj != NULL );
  obj->status = 0;
  // Initialize basic object
  obj->object.name = NULL;
  obj->object.type = TYPE_BUTTON;
  obj->object.x = x;
  obj->object.y = y;
  if (w==0) {
    obj->object.w = strlen(title) + 2; 
  } else {
    obj->object.w = w + 2;
  }

  obj->object.h = 1;
  obj->object.active = FALSE;
  obj->object.enabled = TRUE;
  obj->object.visible = TRUE;
  obj->object.parent = NULL;
  // Add the object to the double-linked list of widgets of this window
  window_AttachObject( win, obj );

  if (gringo_Mode == NCURSES_MODE ) {
    #ifdef USES_NCURSES
    obj->fOnClick = NULL;
    // Set TLabel fields
    obj->caption = (char*) strdup(title);
    obj->caption_color = COLOR_PAIR( COLOR_BLACK_WHITE );
    obj->caption_color_active = A_BOLD | COLOR_PAIR( COLOR_YELLOW_BLUE );
     // Now create the label
    obj->window = derwin(win->window, obj->object.h, obj->object.w, obj->object.y, obj->object.x);
    assert( obj->window != NULL );
    keypad (obj->window, TRUE);
    scrollok (obj->window, FALSE);
    #endif
  } else
  if (gringo_Mode == GTK_MODE ) {
    #ifdef USES_GTK
    obj->widget = gtk_button_new_with_label( (char*)title );
    assert(obj->widget);
    gtk_signal_connect( GTK_OBJECT(obj->widget), "clicked", GTK_SIGNAL_FUNC(button_SetStatus), obj );
    gtk_widget_set_usize( GTK_WIDGET(obj->widget), w * XFACTOR, 1 * YFACTOR );
    gtk_fixed_put( GTK_FIXED(win->fixed), obj->widget, x * XFACTOR, y * YFACTOR );
    gtk_widget_show( GTK_WIDGET(obj->widget) );
    #endif
  }
  return obj;
}
