#include "config.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "badpenguin-fs.h"
#include <gringo.h>
#include "gringosh.h"
#include "parser.h"
#include "gringosh-dump.h"


#define IBUFFER_SIZE		80
#define LBUFFER_SIZE		40

struct {
  int type;
  int x;
  int y;
  int w;
  int h;
  char ibuffer[IBUFFER_SIZE];
  char lname[LBUFFER_SIZE];
/*
	int flag;
*/	
} stoken;

int token_pos    = 0;	// Number of tokens inside of a line
int token_line   = 0;	// Number of processed lines

  TEdit     *edit1    = NULL;
  TButton   *button1  = NULL;
  TCheckBox *check1   = NULL;
  TListBox  *currList = NULL;

void token_init() {
  token_pos = 1;
  stoken.type = TYPE_UNKNOWN;
  stoken.x = 0;
  stoken.y = 0;
  stoken.w = 0;
  stoken.h = 0;
  stoken.ibuffer[0] = 0;
  stoken.lname[0] = 0;
/*  
  stoken.flag = 0;
*/  
}

void token_parse(char *s) {
  // Trim the token left and right
  int l;
  if ((s!=NULL)&&(s[0]!=0)) {
    while ((s[0]== ' ')||(s[0]== '\t')) s++;
  }
  // Trim the token left and right
  if (s!=NULL) {
    l = strlen(s);  
    while ( (l>0) && ( (s[l-1]==' ') || (s[l-1]=='\t') ) ) {
      s[l-1]=0;
      l = strlen(s);
    }
  }
  
  // Parse according to the token position
  switch (token_pos) {
  
    // First token
    case 1: {
      if ( 0 == strcasecmp( "WINDOW", s ) ) {
        if (verbose<=2) printf("- parse(%i,%i) is WINDOW\n", token_line, token_pos );
	stoken.type = TYPE_WINDOW;
        break;	
      } else
      if ( 0 == strcasecmp( "LABEL", s ) ) {
        if (verbose<=2) printf("- parse(%i,%i) is LABEL\n", token_line, token_pos );
	stoken.type = TYPE_LABEL;
      } else
      if ( 0 == strcasecmp( "EDIT", s ) ) {
        if (verbose<=2) printf("- parse(%i,%i) is EDIT\n", token_line, token_pos );
	stoken.type = TYPE_EDITBOX;
      } else
      if ( 0 == strcasecmp( "BUTTON", s ) ) {
        if (verbose<=2) printf("- parse(%i,%i) is BUTTON\n", token_line, token_pos );
	stoken.type = TYPE_BUTTON;	
      } else
      if ( 0 == strcasecmp( "CHECKBOX", s ) ) {
        if (verbose<=2) printf("- parse(%i,%i) is CHECKBOX\n", token_line, token_pos );
	stoken.type = TYPE_CHECKBOX;
      } else
      if ( 0 == strcasecmp( "LISTBOX", s ) ) {
        if (verbose<=2) printf("- parse(%i,%i) is LISTBOX\n", token_line, token_pos );
	stoken.type = TYPE_LISTBOX;
      } else
      if ( 0 == strcasecmp( "LISTITEM", s ) ) {
        if (verbose<=2) printf("- parse(%i,%i) is LISTITEM\n", token_line, token_pos );
	stoken.type = TYPE_LISTITEM;
      } else
      {
        fprintf( stderr, "%s: token unknow at line %i:0 !\n", PACKAGE, token_line );
      }
      break;
    }

    // Second Token
    case 2: {
      switch (stoken.type) {
        case TYPE_WINDOW:
        case TYPE_LABEL:
	case TYPE_EDITBOX:
	case TYPE_BUTTON:
	case TYPE_CHECKBOX:
	case TYPE_LISTBOX:
	{
          if (verbose<=2) printf("- parse(%i,%i) is '.x'\n", token_line, token_pos );
	  if (s==NULL) stoken.x = 0; else stoken.x = atoi(s);
          break;
        }
	case TYPE_LISTITEM:
	{
          if (verbose<=2) printf("- parse(%i,%i) is '.ibuffer'\n", token_line, token_pos );
	  if (s != NULL) {
  	    if (strlen(s) > IBUFFER_SIZE) s[IBUFFER_SIZE-1]=0;
            strcpy(stoken.ibuffer, s);
	  }
	  break;
        }
	default: {
	  fprintf( stderr, "%s: token unknown at line %i:%i !\n", PACKAGE, token_line, token_pos );
        }
      }
      break;
    }

    // Terzo Token
    case 3: {
      switch (stoken.type) {
        case TYPE_WINDOW:
        case TYPE_LABEL:
	case TYPE_EDITBOX:
	case TYPE_BUTTON:
	case TYPE_CHECKBOX:
	case TYPE_LISTBOX:
	{
          if (verbose<=2) printf("- parse(%i,%i) is '.y'\n", token_line, token_pos );
	  if (s==NULL) stoken.y = 0; stoken.y = atoi(s);
          break;
        }
	default: {
	  fprintf( stderr, "%s: token unknown at line %i:%i !\n", PACKAGE, token_line, token_pos );
        }
      }
      break;
    }

    // Quarto Token
    case 4: {
      switch (stoken.type) {
        case TYPE_WINDOW:
        case TYPE_LABEL:
	case TYPE_EDITBOX:
	case TYPE_BUTTON:
	case TYPE_CHECKBOX:
	case TYPE_LISTBOX:
	{
          if (verbose<=2) printf("- parse(%i,%i) is '.w'\n", token_line, token_pos );
	  if (s==NULL) stoken.w=0; else stoken.w = atoi(s);
          break;
        }
	default: {
	  fprintf( stderr, "%s: token unknown at line %i:%i !\n", PACKAGE, token_line, token_pos );
        }
      }
      break;
    }

    // Quinto Token
    case 5: {
      switch (stoken.type) {
        case TYPE_WINDOW:
	case TYPE_LISTBOX:
	{
          if (verbose<=2) printf("- parse(%i,%i) is '.h'\n", token_line, token_pos );
	  if (s==NULL) stoken.h = 0; stoken.h = atoi(s);
          break;
        }
        case TYPE_LABEL:	
	case TYPE_EDITBOX:
	case TYPE_BUTTON:
	case TYPE_CHECKBOX:	
	{
          if (verbose<=2) printf("- parse(%i,%i) is '.ibuffer'\n", token_line, token_pos );
	  if (s != NULL) {
  	    if (strlen(s) > IBUFFER_SIZE) s[IBUFFER_SIZE-1]=0;
            strcpy(stoken.ibuffer, s);
	  }
	  break;
        }
	default: {
	  fprintf( stderr, "%s: token unknown at line %i:%i !\n", PACKAGE, token_line, token_pos );
        }
      }
      break;
    }

    // Sesto Token
    case 6: {
      switch (stoken.type) {
        case TYPE_WINDOW:
	{
          if (verbose<=2) printf("- parse(%i,%i) is '.ibuffer'\n", token_line, token_pos );
	  if (s != NULL) {
	    if (strlen(s) > IBUFFER_SIZE) s[IBUFFER_SIZE-1]=0;
            strcpy(stoken.ibuffer, s);
	  }
	  break;
        }
	case TYPE_EDITBOX:
	case TYPE_BUTTON:
	case TYPE_CHECKBOX:
	case TYPE_LISTBOX:
	{
          if (verbose<=2) printf("- parse(%i,%i) is '.lname'\n", token_line, token_pos );
	  if (s != NULL) {
	    if (strlen(s) > LBUFFER_SIZE) s[LBUFFER_SIZE-1]=0;
            strcpy(stoken.lname, s);
	  }
	  break;
        }
	default: {
	  fprintf( stderr, "%s: token unknown at line %i:%i !\n", PACKAGE, token_line, token_pos );
        }
      }
      break;
    }

    // Default Action
    default: {
      fprintf( stderr, "%s: too many tokens at line %i:%i !\n", PACKAGE, token_line, token_pos );
    }
  }
  token_pos++;
}


void token_finish() {
  
  switch (stoken.type) {
    
    case TYPE_WINDOW: {
      if (token_pos != 7 ) {
        fprintf( stderr, "%s: token at line %i is not completed !\n", PACKAGE, token_line );
      } else {
        if (verbose<=2) printf("- window_Create(%s); \n\n", stoken.ibuffer );
        if (opt_parser_only==0) {
	  currWin = window_Create( stoken.x, stoken.y, stoken.w, stoken.h, stoken.ibuffer );
	  window_OnClose( currWin, gringosh_dump );
	}

      }
      break;
    }

    case TYPE_LABEL: {
      if (token_pos != 6 ) {
        fprintf( stderr, "%s: token at line %i is not completed !\n", PACKAGE, token_line );
      } else {
        if (verbose<=2) printf("- label_Create(%s); \n\n", stoken.ibuffer );
        if (opt_parser_only==0) label_Create( currWin, stoken.x, stoken.y, stoken.w, stoken.ibuffer );
      }
      break;
    }

    case TYPE_EDITBOX: {
      if (token_pos != 7 ) {
        fprintf( stderr, "%s: token at line %i is not completed !\n", PACKAGE, token_line );
      } else {
        if (verbose<=2) printf("- edit_Create(%s); \n\n", stoken.ibuffer );
        if (opt_parser_only==0) {
	  edit1 = edit_Create( currWin, stoken.x, stoken.y, stoken.w, stoken.ibuffer );
          object_SetName( TOBJECT(edit1), stoken.lname );
	}
      }
      break;
    }
    
    case TYPE_BUTTON: {
      if (token_pos != 7 ) {
        fprintf( stderr, "%s: token at line %i is not completed !\n", PACKAGE, token_line );
      } else {
        if (verbose<=2) printf("- button_Create(%s); \n\n", stoken.ibuffer );
        if (opt_parser_only==0) {
	  button1 = button_Create( currWin, stoken.x, stoken.y, stoken.w, stoken.ibuffer );
          object_SetName( TOBJECT(button1), stoken.lname );
	  // add callback
          button_OnClick( button1, gringosh_dump );
	}
      }
      break;
    }

    case TYPE_CHECKBOX: {
      if (token_pos != 7 ) {
        fprintf( stderr, "%s: token at line %i is not completed !\n", PACKAGE, token_line );
      } else {
        if (verbose<=2) printf("- checkbox_Create(%s); \n\n", stoken.ibuffer );
        if (opt_parser_only==0) {
	  check1 = checkbox_Create( currWin, stoken.x, stoken.y, stoken.ibuffer, stoken.w );
          object_SetName( TOBJECT(check1), stoken.lname );
	}
      }
      break;
    }

    case TYPE_LISTBOX: {
      if (token_pos != 7 ) {
        fprintf( stderr, "%s: token at line %i is not completed !\n", PACKAGE, token_line );
      } else {
        if (verbose<=2) printf("- listbox_Create(%s); \n\n", stoken.ibuffer );
        if (opt_parser_only==0) {
	  currList = listbox_Create( currWin, stoken.x, stoken.y, stoken.w, stoken.h );
          object_SetName( TOBJECT(currList), stoken.lname );
	}
      }
      break;
    }

    case TYPE_LISTITEM: {
      if (token_pos != 3 ) {
        fprintf( stderr, "%s: token at line %i is not completed !\n", PACKAGE, token_line );
      } else {
        if (verbose<=2) printf("- listbox_AddItem(%s); \n\n", stoken.ibuffer );
        if (opt_parser_only==0) listbox_AddItem( currList, stoken.ibuffer );
      }
      break;
    }
  }
}


void ParseSourceFile() {
#define RBUFFER_SIZE		160
#define SEPARATORS		"|"
  char readbuffer[RBUFFER_SIZE];
  char *token;
  char *linebuffer;

  if (verbose<=1) printf("- parsing source file \n");
  readbuffer[0]=0;
  while ( ! feof(source_file) ) {
    read_line( source_file, readbuffer );
    linebuffer = strdup(readbuffer);	
    token_line++;
    token = strtoken( &linebuffer, SEPARATORS );
    if (verbose<=0) {
      printf("- linebuffer: %s \n", linebuffer );
      printf("-      token: %s \n", token );
    }
    // discard comment
    if ((token!=NULL)&&(token[0]=='#')) {
      if (verbose<=1) printf("- comment: %s\n", token+1);
      continue;
    }
    token_init();
    while ( (token!=NULL) || ((linebuffer!=NULL) && (linebuffer[0]!=0)) ) {
      token_parse(token);
      // get next token
      token = strtoken( &linebuffer, SEPARATORS );
      if (verbose<=0) {
        printf("- linebuffer: %s \n", linebuffer );
        printf("-      token: %s \n", token );
      }
    }
    token_finish();
    if (verbose<=0) printf("- parsing linebuffer completed.\n");
  }
  if (verbose<=0) printf("- parsing source file completed.\n");
}
