#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gringo.h>
#include "parser.h"

// --- OPTIONS -----

int   opt_use_stdin   = 1;	// use stdin

int   opt_use_stdout   = 1;
char *opt_sourcefile  = NULL;	// use sourcefile
char *opt_targetfile  = NULL;
FILE *source_file     = NULL;   // opened sourcefile
FILE *target_file     = NULL;

int   verbose         = 3;      // verbose level (0=maximum,3=minimum)
int   opt_parser_only = 0;	// check if should only parser
TWindow *currWin = NULL;

void gringosh_banner() {
  printf("%s %s - Shell to execute program using libGringo\n", PACKAGE, VERSION );
  printf("@1999 by Antonio GALLO <agx@linux.it>\n");
  printf("This is a GPL software part of 'Bad Penguin' (www.badpenguin.org)\n\n");
}

void gringosh_options(int argc, char* argv[]) {
  int i=1;
  while (i<argc) {
    if (verbose<=1) printf("- p(%i) = %s \n", i, argv[i] );

    /* "-f" */
    if ( 0 == strcmp( "-f", argv[i] ) ) {
      // do not use stdin
      opt_use_stdin = 0;
      // check for the source filename
      i++;
      if (i<argc) {
        opt_sourcefile = strdup(argv[i]);
        if (verbose<=1) printf( "- using %s as source file \n", opt_sourcefile );
      } else {
        fprintf( stderr, "%s: you used the -f option but without specifing any filename !\n", PACKAGE );
        exit(1);
      }

    }
 else

    /* "-o" */
    if ( 0 == strcmp( "-o", argv[i] ) ) {
      // do not use stdin
      opt_use_stdout = 0;
      // check for the source filename
      i++;
      if (i<argc) {
        opt_targetfile = strdup(argv[i]);
        if (verbose<=1) printf( "- using %s as target file \n", opt_targetfile );
      } else {
        fprintf( stderr, "%s: you used the -o option but without specifing any filename !\n", PACKAGE );
        exit(1);
      }

    }
 else

    /* "--parser-only" */
    if ( 0 == strcmp( "--parser-only", argv[i] ) ) {
      // do not use stdin
      opt_parser_only = 1;
      verbose = 2;
    }

    /* "-v --verbose" */
    if ( (0==strcmp("-v",argv[i])) || (0==strcmp("--verbose",argv[i])) ) {
      verbose--;
      if (verbose==0) printf("- verbose as reached the maximum detail level");
    }

    /* "--debug" */
    if (0==strcmp("--debug",argv[i])) {
      verbose=0;
      printf("- verbose as reached the maximum detail level");
    }

    /* "-V --version" */
    if ( (0==strcmp("-V",argv[i])) || (0==strcmp("--version",argv[i])) ) {
      gringosh_banner();
      exit(1);
    }

    // Next
    i++;
  }
}

void gringosh_open_sourcefile() {
  if ( opt_use_stdin == 0 ) {
    source_file = fopen( opt_sourcefile, "r" );
    if ( NULL == source_file ) {
      fprintf( stderr, "%s: impossibile aprire il file sorgente %s !\n", PACKAGE, opt_sourcefile );
      exit(1);
    }
    if (verbose<=1) printf( "- apertura dell'input da %s \n", opt_sourcefile );
    

  } else {
    source_file = stdin;
    if (verbose<=1) printf( "- apertura dello standard input \n" );
  }
}

void gringosh_open_targetfile() {
  if ( opt_use_stdout == 0 ) {
    target_file = fopen( opt_targetfile, "w" );
    if ( NULL == target_file ) {
      fprintf( stderr, "%s: unable to open target file %s !\n", PACKAGE, opt_targetfile );
      exit(1);
    }
    if (verbose<=1) printf( "- writing output to %s \n", opt_targetfile );
    

  } else {
    target_file = stdout;
    if (verbose<=1) printf( "- apertura dello standard output \n" );
  }
}

int main(int argc, char* argv[])
 {

  // Checking Parameters
  gringosh_options( argc, argv );
  // Open the source file
  gringosh_open_sourcefile();  
  gringosh_open_targetfile();  
  // Start libGringo
  if (opt_parser_only==0) gringo_Init( &argc, &argv );
  // Parse the file and create widgets
  ParseSourceFile();
  // Release
 the input file
  if ( opt_use_stdin == 0 ) fclose( source_file );
  // Activate libGringo
  if (opt_parser_only==0) {
    gringo_Loop();
    gringo_Quit();
  }
  if ( opt_use_stdout == 0 ) fclose( target_file );
  return 0;
}	
