#include "config.h"
#include <stdio.h>

#include <gringo.h>
#include "gringosh.h"

void gringosh_dump() {
  TChainItem *win;
  TChainItem *item;
  int widgetType = TYPE_UNKNOWN;
  int btnValue = 0;
  int btnTrigger = 0;
  
  win = gringo_Windows->head;
  while (win!=NULL) {
    // scan items
    window_OnClose( TWINDOW(win->data), NULL );
    item = TWINDOW(win->data)->widgets->head;
    while (item!=NULL) {
      // .........
      //fprintf(stderr, "#NAME: %s \n", TOBJECT(item->data)->name );      
      widgetType = TOBJECT(item->data)->type;
      switch (widgetType) {
        case TYPE_EDITBOX: {
	  fprintf(target_file, "%s=\"%s\"\n", TOBJECT(item->data)->name, edit_GetValue( TEDIT(item->data) ) );
          break;
        }
        case TYPE_BUTTON: {
	  btnValue = button_GetValue( TBUTTON(item->data) );
	  btnTrigger += btnValue;
	  fprintf(target_file, "%s=%i\n", TOBJECT(item->data)->name, button_GetValue( TBUTTON(item->data) ) );
          break;
        }
        case TYPE_CHECKBOX: {
	  fprintf(target_file, "%s=%i\n", TOBJECT(item->data)->name, checkbox_GetValue( TCHECKBOX(item->data) ) );
          break;
        }
        case TYPE_LISTBOX: {
	  fprintf(target_file, "%s=\"%s\"\n", TOBJECT(item->data)->name, listbox_GetValue( TLISTBOX(item->data) ) );
          break;
        }

      }      
      // next item
      item=item->next;
    }
    // next window
    win=win->next;
  }
  // check the trigger
  if (btnTrigger>0) {
    fprintf(target_file, "GRINGOSH=1\n");  
  } else {
    fprintf(target_file, "GRINGOSH=0\n");
  }
  // exit...
  gringo_Terminate(0);
}
