// Condiskcat.cpp v0.95b - Disk cataloging and searching utility
// Copyright (C) 2005  Andy Alt <andyqwerty@users.sourceforge.net>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, 
//  Boston, MA  02111-1307  USA

#include <cstdlib>
#include <string>
#include <iostream>
#include <fstream>

using namespace std;

#define debug 0
#define NAME "Console Disk Cataloger"
#define Version "v0.95b"
#define FileName "condiskcat"
#define VerDate "04-25-2005"
#define HIGHLIGHT "-"



void FileNotFound();
void FoundIt(int, string, char*);
void CheckName(int);
void banner();
void DisplayResults(string,string);
void Again();
void Char2Dec(string, int*, int);
void DisplayStatus(char*, string);
void Goodbye();
void License();
void CheckLen(int);
void SearchNext(int, char*);
void Skip(char*);

char YesNo();
bool create_dir_entry, STOP=0;
unsigned short for_m;


int main (int argc, char *argv[]) { // begin main

int argc_1 = argc;

    if (argc > 1) {
	if (!strcmp(argv[1],"--license")) License();
	}
	

    if (argc > 1) {
	if (!strcmp(argv[1],"--help")) argc_1 = 1;
	}
	
    // First thing, gonna check to see if it was given a
    // filename to search

    
    CheckName(argc_1);

// Thinking about implementing some ncurses functions later.
//    (void) initscr();
//    keypad (stdscr, TRUE);
//    (void) nonl();
//    (void) cbreak();
//    (void) noecho();
    
    unsigned short input_len;
    unsigned short found = 0;

    // vars used in 'for' loops
    unsigned short int for_j, for_k;

    unsigned short int s1,s2;
    char sa = '\0';
    char lib_file[100]; 
    string input_search;
    unsigned short sLen;
    int search_ascii[41];
    unsigned short comparing = 0;
    string file_search;
    string directory;
    int Spos;
    string Schar;
    int SSLen;
    
    // A main program loop... until argc is reached, or user presses
    // "n" when asked to search another library
    for (for_m = 1; for_m < argc ;for_m++) { // begin for 1
	fstream inputfile;
	strcpy(lib_file, argv[for_m]);
	inputfile.open(lib_file);
	
	if (inputfile.fail())
	    FileNotFound();

	// only process the the search string if this is the
	// first run through the main loop, indicated above.
	if (for_m == 1) { // begin 'for' 3
	    banner();
	    
	    do {
		cout << "Enter Search String: ";
	        getline (cin, input_search);
		input_len = input_search.length();
		if (!input_len) {
		    cout << "\nPlease try to enter at least one more character this time\n\n";
		    }
		    
		} while (!input_len);
			
	    for (for_j=0;for_j < input_len;for_j++) {
	    	input_search[for_j] = tolower(input_search[for_j]);
		}
		sLen = input_search.length();
		CheckLen(sLen);
	    // This will create an integer array matching the char
	    // array of the search string; used later
		Char2Dec(input_search, search_ascii, sLen);
	    } // end 'for' 3

	DisplayStatus(lib_file,input_search);
    
	while (!inputfile.eof() && !STOP) { //  begin while 1
	    Spos=0;
	    getline (inputfile, file_search);
	    SSLen = file_search.length();

	    for (for_k=0;for_k < SSLen; for_k++) { // begin for 2

		file_search.at(Spos) = tolower(file_search.at(Spos));
		s1 = search_ascii[comparing];
		s2 = toascii(file_search.at(Spos));  

		// As of v0.92, made sure this is irrelevant unless
		// Spos is also equal to zero. Means the first character
		// of the new line it just read from a libary. Forward
		// slashes (ascii 47) elsewhere will be ignored.
		if (s2 == 47 && (create_dir_entry == 0) && !Spos) {
		// First instance of a "/" then set _cde_ to 1,
		// and make sure the directory var is cleared
		    create_dir_entry=1;
		    directory.erase();
		    }

		// if _cde_ is still one, then append the current 
		// character to "directory"				
		if (create_dir_entry) {
		    Schar = file_search.at(Spos);
		    directory.append(Schar);
		    }

		// If a colon is found, treat as if the end
		// of directory has been reached
		if (s2 == 58) create_dir_entry=0;
	        comparing++;
		if (s1 != s2) comparing=0;

/* Basically, if "comparing" is equal to the length of the input search string
treat it as if the string was found. Each time there is not match, "comparing"
is reset to 0. Every time the statements between the feof checking loop, comparing
incremented by 1, until there is no match. Most of the time, comparing will be reset
to zero. When it keeps finding the characters matching, I will increment
until it matches the length of the input search string. Very inefficient;
I'll fix it later. Directly below, using input_len-1 will make sure it
doesn't have to be an exact match since it matches before a null terminator
of the line it reads from the catalog library, which would signal the end
of the filename.   */
	
		if (comparing == input_len) {

		    if (create_dir_entry == 1) {
    			create_dir_entry = 0;
			directory = file_search;
			}
		    
		    if (found) 
			DisplayStatus(lib_file, input_search);
			
		    DisplayResults(directory,file_search);
		    Again();
		    found++;
		    comparing=0;
		    if (STOP) for_k=SSLen;
		    }

		Spos++;	  
		}  // end for 2

	    } // end while 1
	    STOP=0;

	FoundIt(found, input_search, lib_file);
        found = 0;
        inputfile.close();
	    
	    do	{	    
		    SearchNext(argc, argv[for_m+1]);
		    sa = YesNo();
		    if (sa == 110) Goodbye();
	    	    if (sa == 115) Skip(argv[for_m+1]);
		    } while (sa == 115);

	    
	    
//	else cout << "End of the Road\n"; 
	
    } // end for 1

Goodbye();

} // end main

void FileNotFound() {
    cout << "\n\tERROR:Catalog file not found. Exiting...\n";
    Goodbye();
}

void FoundIt(int found, string input_search, char *lib_file) {
    if (!found) {
	cout << "\nSorry, but \"" << input_search << "\" wasn't found in ";
	cout << HIGHLIGHT << lib_file << HIGHLIGHT << "\n";
    }

    if (found) {
	cout << "\n* Found " << found << " ocurrences of ";
	cout << "\""  << input_search << "\" in ";
	cout << HIGHLIGHT << lib_file << HIGHLIGHT "\n";
	cout << endl;
    }
}

void CheckName(int argc) {
    if (argc == 1)	{
	cout << endl << FileName << " " << Version;
	cout << " - " << NAME << "\n";
	cout << "Usage: " << FileName << " *\n";
	cout << "       " << FileName << " <filename> <filename> <filename>\n";
	cout << "       " << FileName << " <filename> cdro* <filename> *\n";
	cout << "       --license\n";
	cout << "       --help\n\n";
	exit(0);
    }
}

void banner() {
    int charloop;
    cout << "\n\n";
    cout << NAME << " - " << VerDate << endl;
    for (charloop=0; charloop<40; charloop++)
	cout << "=";
    
    cout << endl;

    cout << "\n"; 
//    cout << "     " << NAME << " "<< Version << "\n";
    cout << "      " << FileName << " " << Version << "\n";
    cout << "      by Andy Alt\n";
    cout << "\n";
    
    for (charloop=0; charloop<40; charloop++)
	cout << "=";
	
    cout << endl;
}

void DisplayResults(string directory, string file_search) {
    cout << "\n";
    cout << directory << "\n";
    cout << file_search << "\n";
}

void Again() {
    char yes_no;
    cout << "! Found this one, but would you like to continue (y/n/s)? ";
    yes_no = YesNo();
    if (yes_no == 110) Goodbye();
    if (yes_no == 115) STOP=1;
}

void Char2Dec(string input_search,int* search_ascii, int sLen) {
    int for_j;

    for ( for_j = 0; for_j < sLen ; for_j++ ) {
	search_ascii[for_j] = toascii(input_search.at(for_j));
    }
}

void DisplayStatus(char *lib_file, string input_search) {
    cout << "\n! Currently searching ";
    cout << HIGHLIGHT << lib_file << HIGHLIGHT;
    cout << " for \"" << input_search << "\"...\n";
}

void Goodbye() {
    cout << "\nThanks for using me!\n";
    cout << "\nGoodbye.\n\n";
    exit(0);
}

char YesNo() {
    char yes_no = '\0';
    char YES_NO[2];

    while (yes_no != 'n' && yes_no != 'y' && yes_no != 's'){
	if (!cin) cin.ignore(80, '\n');
	cin.get(yes_no);
	
	YES_NO[0] = yes_no;
	yes_no = tolower(YES_NO[0]);
	
	if (yes_no != 'n' && yes_no != 'y' && yes_no != 's') {
	    cout << "y/n/s? ";
	    if (yes_no != 10) cin.ignore(80, '\n');
	}
    }
       if (cin) cin.ignore(80, '\n');
    return yes_no;
}

void License() {
cout << NAME << " " << Version << ", Copyright (C) 2005  Andy Alt\n";
cout << endl;
cout << "This program is free software; you can redistribute it and/or modify\n";
cout << "it under the terms of the GNU General Public License as published by\n";
cout << "the Free Software Foundation; either version 2 of the License, or\n";
cout << "(at your option) any later version.\n";
cout << endl;
cout << "This program is distributed in the hope that it will be useful,\n";
cout << "but WITHOUT ANY WARRANTY; without even the implied warranty of\n";
cout << "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n";
cout << "GNU General Public License for more details.\n";
cout << endl;
cout << "You should have received a copy of the GNU General Public License\n";
cout << "along with this program; if not, write to the Free Software\n";
cout << "Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.\n";
cout << endl;
exit(0);
}

void CheckLen(int sLen) {
    if (sLen > 40) {
	cout << "\n! Search string must be 40 characters or less";
	Goodbye();
	}
}

void SearchNext (int argc, char *argv) {
	if (for_m == (argc - 1)) Goodbye();
    	if (for_m < argc-1) {
	    cout << "Would you like to search ";
    	    cout << HIGHLIGHT << argv << HIGHLIGHT;
            cout << " (y/n/s)? ";
	    }
	    
	    
}

void Skip(char *argv) {
    for_m++;
    cout << endl;
    cout << "% Skipping " << HIGHLIGHT << argv << HIGHLIGHT;
    cout << endl;    
}
