#!/bin/sh
# Diskcat.sh v0.5b - To be used in conjunction with condiskcat
#
# To be assured of a complete directory listing, this script would
# have to be run as root or with sudo access.
#
# This script will create dirs as needed.
#
# Problem with this, is if it's run sudo before the ~/diskcat or 
# ~/diskcat/<device> dirs are created, they will be owned by root.
# Also if the .dir files don't already exist, they will be owned by root

clear
echo ""
echo "Console Disk Cataloger script v0.5b"
echo "File Library generation script for condiskcat v0.95b - 04/25/2005"

usage() {
	echo ""	
	echo "	Usage: diskcat.sh <src-dir> <target-file>"
	echo "	Example: diskcat.sh cdrom cd_one.dir"
	echo
	echo "Output of /mnt/cdrom will be sent to $HOME/diskcat/cdrom/cd_one.dir"
	echo "as a plain text file. Use 'condiskcat' to search"
	echo ""
}


if [ ! -x ~/diskcat ]; then
	mkdir ~/diskcat
fi

if [ "$1" == '' ]; then
usage
	
elif [ "$2" == '' ]; then
usage
	
else 
	if [ ! -x ~/diskcat/$1 ]; then
		mkdir ~/diskcat/$1
	fi
	echo "Cataloging $1 to $2"
	ls -al -R /mnt/$1 > ~/diskcat/$1/$2
	du -h /mnt/$1 >> ~/diskcat/$1/$2
	echo "Output sent to $HOME/diskcat/$1/$2"
fi
