/*
 * name.2.c
 * Copyright (C) 2006-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include <string.h>

#include <aime.h>

static int check_list(const char *, struct x1f4_variable_type *, unsigned);

static int
check_list(const char *name, struct x1f4_variable_type *variable_data,
	   unsigned count)
{
    for (; count; count--) {
	if (!strcmp(name, variable_data->name)) {
	    break;
	}

	variable_data++;
    }

    return count;
}


int
libx1f4i0_miss_name(const char *self, const char *miss, const char *name,
		    unsigned i, void *list)
{
    int status;

    if (x1f4_check_identifier(name)) {
	status = 1;
	fprintf(stderr, "%s: invalid name for %s %u: `%s'\n", self, miss, i,
		name);
    } else {
	if (check_list(name, list, i)) {
	    status = 1;
	    fprintf(stderr, "%s: duplicate name for %s %u: `%s'\n", self, miss,
		    i, name);
	} else {
	    status = 0;
	}
    }

    return status;
}
