/*
 * miss.3.c
 * Copyright (C) 2007-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4l0
# include <libx1f4l0.h>
# include <stdio.h>
#endif				/* HAVE_LIBx1f4l0 */

#if defined HAVE_LIBx1f4l0
# include <as.h>
#endif				/* HAVE_LIBx1f4l0 */

#if defined HAVE_LIBx1f4l0
int
libx1f4i0_fini_valist(const char *self, void *valist, int do_memory,
		      int do_storage, int *status)
{
    if (valist) {
	unsigned linger;

	if (!(do_memory | do_storage)) {
# if __BALIST_ONLY__
	    x1f4_size_balist(valist, &linger);
# else
	    x1f4_size_valist(valist, &linger);
# endif				/* __BALIST_ONLY__ */
	} else {
# if __USE_BALIST__
	    x1f4_size_balist(valist, &linger);
# else
	    x1f4_size_xalist(valist, &linger);
# endif				/* __USE_BALIST__ */
	}
	if (linger) {
	    unsigned record;

	    if (!(do_memory | do_storage)) {
# if __BALIST_ONLY__
		x1f4_post_balist(valist, &record);
# else
		x1f4_post_valist(valist, &record);
# endif				/* __BALIST_ONLY__ */
	    } else {
# if __USE_BALIST__
		x1f4_post_balist(valist, &record);
# else
		x1f4_post_xalist(valist, &record);
# endif				/* __USE_BALIST__ */
	    }
	    fprintf(stderr, "%s: memory is leaking (%u byte%s, %u block%s?)\n",
		    self, linger, linger == 1 ? "" : "s", record,
		    record == 1 ? "" : "s");
	    *status = 1;
	}
	if (!(do_memory | do_storage)) {
# if __BALIST_ONLY__
	    x1f4_fini_balist(&valist);
# else
	    x1f4_fini_valist(&valist);
# endif				/* __BALIST_ONLY__ */
	} else {
# if __USE_BALIST__
	    x1f4_fini_balist(&valist);
# else
	    x1f4_fini_xalist(&valist);
# endif				/* __USE_BALIST__ */
	}
    }

    return 0;
}
#endif				/* HAVE_LIBx1f4l0 */
