/*
 * miss.1.c
 * Copyright (C) 2007-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4l0
# include <libx1f4l0.h>
# include <stdio.h>
#endif				/* HAVE_LIBx1f4l0 */

#if defined HAVE_LIBx1f4l0
# include <as.h>
# include <types.h>
#endif				/* HAVE_LIBx1f4l0 */

#if defined HAVE_LIBx1f4l0
static int free_list(void *, void *);
static int link_list(void *, void **, unsigned);
static int mode_list(void *, void **, unsigned);
#endif				/* HAVE_LIBx1f4l0 */

#if defined HAVE_LIBx1f4l0
static int
free_list(void *list, void *data)
{
    int status;
    struct list_type *list_data;
    unsigned last;

    list_data = list;

# if __USE_BALIST__
    status = x1f4_hack_balist(list_data->valist, data, &last);
# else
    status = x1f4_hack_xalist(list_data->valist, data, &last);
# endif				/* __USE_BALIST__ */
    if (status) {
    } else {
	list_data->size -= last;

	fprintf(stderr, " %+7d\n", -(int) last);
    }

    return status;
}
#endif				/* HAVE_LIBx1f4l0 */


#if defined HAVE_LIBx1f4l0
static int
link_list(void *list, void **data, unsigned size)
{
    int status;
    struct list_type *list_data;

    list_data = list;

# if __USE_BALIST__
    status = x1f4_link_balist(list_data->valist, data, size);
# else
    status = x1f4_link_xalist(list_data->valist, data, size);
# endif				/* __USE_BALIST__ */
    if (status) {
    } else {
	unsigned clip;

	clip = list_data->size + size;
	list_data->size = clip;
	if (list_data->ever < clip) {
	    list_data->ever = clip;
	}

	fprintf(stderr, " %7u\n", size);
    }

    return status;
}
#endif				/* HAVE_LIBx1f4l0 */


#if defined HAVE_LIBx1f4l0
static int
mode_list(void *list, void **data, unsigned size)
{
    int status;
    struct list_type *list_data;
    unsigned last;

    list_data = list;

# if __USE_BALIST__
    status = x1f4_node_balist(list_data->valist, data, size, &last);
# else
    status = x1f4_node_xalist(list_data->valist, data, size, &last);
# endif				/* __USE_BALIST__ */
    if (status) {
    } else {
	unsigned clip;

	clip = list_data->size + size - last;
	list_data->size = clip;
	if (list_data->ever < clip) {
	    list_data->ever = clip;
	}

	fprintf(stderr, " %+7d\n", (int) size - (int) last);
    }

    return status;
}
#endif				/* HAVE_LIBx1f4l0 */


#if defined HAVE_LIBx1f4l0
int
libx1f4i0_lead_valist(void *valist, int do_memory, int do_storage, void *trans,
		      void *delete)
{
    if (1) {
	struct x1f4_trans_type *trans_data;

	trans_data = trans;
	if (do_memory) {
	    trans_data->context = delete;
	    trans_data->free = free_list;
	    trans_data->link = link_list;
	    trans_data->mode = mode_list;
	} else {
	    if (do_storage) {
		trans_data->context = valist;
# if __USE_BALIST__
		trans_data->free = x1f4_free_balist;
		trans_data->link = x1f4_link_balist;
		trans_data->mode = x1f4_mode_balist;
# else
		trans_data->free = x1f4_free_xalist;
		trans_data->link = x1f4_link_xalist;
		trans_data->mode = x1f4_mode_xalist;
# endif				/* __USE_BALIST__ */
	    } else {
		trans_data->context = valist;
# if __BALIST_ONLY__
		trans_data->free = x1f4_free_balist;
		trans_data->link = x1f4_link_balist;
		trans_data->mode = x1f4_mode_balist;
# else
		trans_data->free = x1f4_free_valist;
		trans_data->link = x1f4_link_valist;
		trans_data->mode = x1f4_mode_valist;
# endif				/* __BALIST_ONLY__ */
	    }
	}
    }

    return 0;
}
#endif				/* HAVE_LIBx1f4l0 */


#if defined HAVE_LIBx1f4l0
int
libx1f4i0_line_valist(void *valist, int do_memory, int do_storage,
		      int (**free) (void *, void *),
		      int (**link) (void *, void **, unsigned),
		      int (**mode) (void *, void **, unsigned), void **data,
		      void *delete)
{
    if (valist) {
	if (do_memory) {
	    struct list_type *list_data;

	    *data = delete;
	    *free = free_list;
	    *link = link_list;
	    *mode = mode_list;
	    list_data = delete;
	    list_data->valist = valist;
	} else {
	    if (do_storage) {
		*data = valist;
# if __USE_BALIST__
		*free = x1f4_free_balist;
		*link = x1f4_link_balist;
		*mode = x1f4_mode_balist;
# else
		*free = x1f4_free_xalist;
		*link = x1f4_link_xalist;
		*mode = x1f4_mode_xalist;
# endif				/* __USE_BALIST__ */
	    } else {
		*data = valist;
# if __BALIST_ONLY__
		*free = x1f4_free_balist;
		*link = x1f4_link_balist;
		*mode = x1f4_mode_balist;
# else
		*free = x1f4_free_valist;
		*link = x1f4_link_valist;
		*mode = x1f4_mode_valist;
# endif				/* __BALIST_ONLY__ */
	    }
	}
    }

    return 0;
}
#endif				/* HAVE_LIBx1f4l0 */
