/*
 * line.1.c
 * Copyright (C) 2007, 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>

#include <aime.h>
#include <line.h>

#define MAKE_SINGLE(a, b)		a

#define I_MODE(i)			(*((X1f4_E4_C_MODE *) (i)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_USER(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

extern void *global_context;

static int c11xx_l__(void *, void **);
static int c11xx_p__(void *, void **);
static int c11xx_q__(void *, void **);
static int c12xx_l__(void *, void **);
static int c12xx_p__(void *, void **);
static int c12xx_q__(void *, void **);
static int c21xx_l_l(void *, void **);
static int c21xx_p_p(void *, void **);
static int c21xx_q_q(void *, void **);
static int c22xx_l_l(void *, void **);
static int c22xx_p_p(void *, void **);
static int c22xx_q_q(void *, void **);
static int c23xx_l_m(void *, void **);
static int c23xx_p_m(void *, void **);
static int c23xx_q_m(void *, void **);
static int c24xx_l_m(void *, void **);
static int c24xx_p_m(void *, void **);
static int c24xx_q_m(void *, void **);
static int c25xx_l_p(void *, void **);
static int c25xx_q_p(void *, void **);
static int c26xx_l_p(void *, void **);
static int c26xx_q_p(void *, void **);
static int c27xx_l_q(void *, void **);
static int c28xx_l_q(void *, void **);
static int c77xx_l_l(void *, void **);
static int c77xx_p_p(void *, void **);
static int c77xx_q_q(void *, void **);

static const int c_____l__[] = {
/* *INDENT-OFF* */
    EX20_E4_LINE
/* *INDENT-ON* */
}, c_____l_l[] = {
/* *INDENT-OFF* */
    EX20_E4_LINE,
    EX20_E4_LINE
/* *INDENT-ON* */
}, c_____l_m[] = {
/* *INDENT-OFF* */
    EX20_E4_LINE,
    X1f4_E4_MODE
/* *INDENT-ON* */
}, c_____l_p[] = {
/* *INDENT-OFF* */
    EX20_E4_LINE,
    EX20_E4_PAIR
/* *INDENT-ON* */
}, c_____l_q[] = {
/* *INDENT-OFF* */
    EX20_E4_LINE,
    EX20_E4_QUAD
/* *INDENT-ON* */
}, c_____p__[] = {
/* *INDENT-OFF* */
    EX20_E4_PAIR
/* *INDENT-ON* */
}, c_____p_m[] = {
/* *INDENT-OFF* */
    EX20_E4_PAIR,
    X1f4_E4_MODE
/* *INDENT-ON* */
}, c_____p_p[] = {
/* *INDENT-OFF* */
    EX20_E4_PAIR,
    EX20_E4_PAIR
/* *INDENT-ON* */
}, c_____q__[] = {
/* *INDENT-OFF* */
    EX20_E4_QUAD
/* *INDENT-ON* */
}, c_____q_m[] = {
/* *INDENT-OFF* */
    EX20_E4_QUAD,
    X1f4_E4_MODE
/* *INDENT-ON* */
}, c_____q_p[] = {
/* *INDENT-OFF* */
    EX20_E4_QUAD,
    EX20_E4_PAIR
/* *INDENT-ON* */
}, c_____q_q[] = {
/* *INDENT-OFF* */
    EX20_E4_QUAD,
    EX20_E4_QUAD
/* *INDENT-ON* */
};
static const struct x1f4_operator_type e11xx_l__[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("+", " "),  c11xx_l__,	1024,
	EX20_E4_LINE,		c_____l__,
	0,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e11xx_p__[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("+", " "),  c11xx_p__,	1024,
	EX20_E4_PAIR,		c_____p__,
	0,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e11xx_q__[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("+", " "),  c11xx_q__,	1024,
	EX20_E4_QUAD,		c_____q__,
	0,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e12xx_l__[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("-", " "),  c12xx_l__,	1024,
	EX20_E4_LINE,		c_____l__,
	0,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e12xx_p__[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("-", " "),  c12xx_p__,	1024,
	EX20_E4_PAIR,		c_____p__,
	0,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e12xx_q__[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("-", " "),  c12xx_q__,	1024,
	EX20_E4_QUAD,		c_____q__,
	0,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e21xx_l_l[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("+", " "),  c21xx_l_l,	1024,
	EX20_E4_LINE,		c_____l_l,
	0,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e21xx_p_p[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("+", " "),  c21xx_p_p,	1024,
	EX20_E4_PAIR,		c_____p_p,
	0,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e21xx_q_q[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("+", " "),  c21xx_q_q,	1024,
	EX20_E4_QUAD,		c_____q_q,
	0,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e22xx_l_l[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("-", " "),  c22xx_l_l,	1024,
	EX20_E4_LINE,		c_____l_l,
	0,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e22xx_p_p[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("-", " "),  c22xx_p_p,	1024,
	EX20_E4_PAIR,		c_____p_p,
	0,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e22xx_q_q[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("-", " "),  c22xx_q_q,	1024,
	EX20_E4_QUAD,		c_____q_q,
	0,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e23xx_l_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("+", " "),  c23xx_l_m,	1024,
	EX20_E4_LINE,		c_____l_m,
	0,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e23xx_p_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("+", " "),  c23xx_p_m,	1024,
	EX20_E4_PAIR,		c_____p_m,
	0,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e23xx_q_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("+", " "),  c23xx_q_m,	1024,
	EX20_E4_QUAD,		c_____q_m,
	0,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e24xx_l_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("-", " "),  c24xx_l_m,	1024,
	EX20_E4_LINE,		c_____l_m,
	0,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e24xx_p_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("-", " "),  c24xx_p_m,	1024,
	EX20_E4_PAIR,		c_____p_m,
	0,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e24xx_q_m[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("-", " "),  c24xx_q_m,	1024,
	EX20_E4_QUAD,		c_____q_m,
	0,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e25xx_l_p[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("+", " "),  c25xx_l_p,	1024,
	EX20_E4_LINE,		c_____l_p,
	0,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e25xx_q_p[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("+", " "),  c25xx_q_p,	1024,
	EX20_E4_QUAD,		c_____q_p,
	0,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e26xx_l_p[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("-", " "),  c26xx_l_p,	1024,
	EX20_E4_LINE,		c_____l_p,
	0,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e26xx_q_p[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("-", " "),  c26xx_q_p,	1024,
	EX20_E4_QUAD,		c_____q_p,
	0,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e27xx_l_q[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("+", " "),  c27xx_l_q,	1024,
	EX20_E4_LINE,		c_____l_q,
	0,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e28xx_l_q[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("-", " "),  c28xx_l_q,	1024,
	EX20_E4_LINE,		c_____l_q,
	0,			1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e77xx_l_l[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("=", " "),  c77xx_l_l,	4096,
	EX20_E4_LINE,		c_____l_l,
	X1f4_E4_LEFT_XSET,	1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e77xx_p_p[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("=", " "),  c77xx_p_p,	4096,
	EX20_E4_PAIR,		c_____p_p,
	X1f4_E4_LEFT_XSET,	1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e77xx_q_q[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("=", " "),  c77xx_q_q,	4096,
	EX20_E4_QUAD,		c_____q_q,
	X1f4_E4_LEFT_XSET,	1,
	NULL,			NULL				}
/* *INDENT-ON* */
};
const struct x1f4_operator_type *_libx1f4i0_e4_line_1[] = {
/* *INDENT-OFF* */
    e11xx_l__,
    e11xx_p__,
    e11xx_q__,
    e12xx_l__,
    e12xx_p__,
    e12xx_q__
/* *INDENT-ON* */
}, *_libx1f4i0_e4_line_2[] = {
/* *INDENT-OFF* */
    e21xx_l_l,
    e21xx_p_p,
    e21xx_q_q,
    e22xx_l_l,
    e22xx_p_p,
    e22xx_q_q,
    e23xx_l_m,
    e23xx_p_m,
    e23xx_q_m,
    e24xx_l_m,
    e24xx_p_m,
    e24xx_q_m,
    e25xx_l_p,
    e25xx_q_p,
    e26xx_l_p,
    e26xx_q_p,
    e27xx_l_q,
    e28xx_l_q,
    e77xx_l_l,
    e77xx_p_p,
    e77xx_q_q
/* *INDENT-ON* */
};

static int
c11xx_l__(void *output, void **input)
{
    l_USER(I_USER(input[0]), output);

    return 0;
}


static int
c11xx_p__(void *output, void **input)
{
    l_USER(I_USER(input[0]), output);

    return 0;
}


static int
c11xx_q__(void *output, void **input)
{
    l_USER(I_USER(input[0]), output);

    return 0;
}


static int
c12xx_l__(void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data, *text;
	struct line_type *back_line;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	back_line = I_USER(input[0]);

	data = line_data->data;

	text = back_line->data;

	data[0] = -text[0];
	data[1] = -text[1];
	data[2] = -text[2];
	data[3] = -text[3];
	data[4] = -text[4];
	data[5] = -text[5];
	data[6] = -text[6];
	data[7] = -text[7];

	l_USER(line_data, output);
    }

    return status;
}


static int
c12xx_p__(void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data, *text;
	struct line_type *back_line;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	back_line = I_USER(input[0]);

	data = line_data->data;

	text = back_line->data;

	data[0] = -text[0];
	data[1] = -text[1];

	l_USER(line_data, output);
    }

    return status;
}


static int
c12xx_q__(void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data, *text;
	struct line_type *back_line;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	back_line = I_USER(input[0]);

	data = line_data->data;

	text = back_line->data;

	data[0] = -text[0];
	data[1] = -text[1];
	data[2] = -text[2];
	data[3] = -text[3];

	l_USER(line_data, output);
    }

    return status;
}


static int
c21xx_l_l(void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data, *sail, *text;
	struct line_type *back_line, *left_line;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	left_line = I_USER(input[0]);
	back_line = I_USER(input[1]);

	data = line_data->data;

	sail = left_line->data;
	text = back_line->data;

	data[0] = sail[0] + text[0];
	data[1] = sail[1] + text[1];
	data[2] = sail[2] + text[2];
	data[3] = sail[3] + text[3];
	data[4] = sail[4] + text[4];
	data[5] = sail[5] + text[5];
	data[6] = sail[6] + text[6];
	data[7] = sail[7] + text[7];

	l_USER(line_data, output);
    }

    return status;
}


static int
c21xx_p_p(void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data, *sail, *text;
	struct line_type *back_line, *left_line;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	left_line = I_USER(input[0]);
	back_line = I_USER(input[1]);

	data = line_data->data;

	sail = left_line->data;
	text = back_line->data;

	data[0] = sail[0] + text[0];
	data[1] = sail[1] + text[1];

	l_USER(line_data, output);
    }

    return status;
}


static int
c21xx_q_q(void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data, *sail, *text;
	struct line_type *back_line, *left_line;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	left_line = I_USER(input[0]);
	back_line = I_USER(input[1]);

	data = line_data->data;

	sail = left_line->data;
	text = back_line->data;

	data[0] = sail[0] + text[0];
	data[1] = sail[1] + text[1];
	data[2] = sail[2] + text[2];
	data[3] = sail[3] + text[3];

	l_USER(line_data, output);
    }

    return status;
}


static int
c22xx_l_l(void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data, *sail, *text;
	struct line_type *back_line, *left_line;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	left_line = I_USER(input[0]);
	back_line = I_USER(input[1]);

	data = line_data->data;

	sail = left_line->data;
	text = back_line->data;

	data[0] = sail[0] - text[0];
	data[1] = sail[1] - text[1];
	data[2] = sail[2] - text[2];
	data[3] = sail[3] - text[3];
	data[4] = sail[4] - text[4];
	data[5] = sail[5] - text[5];
	data[6] = sail[6] - text[6];
	data[7] = sail[7] - text[7];

	l_USER(line_data, output);
    }

    return status;
}


static int
c22xx_p_p(void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data, *sail, *text;
	struct line_type *back_line, *left_line;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	left_line = I_USER(input[0]);
	back_line = I_USER(input[1]);

	data = line_data->data;

	sail = left_line->data;
	text = back_line->data;

	data[0] = sail[0] - text[0];
	data[1] = sail[1] - text[1];

	l_USER(line_data, output);
    }

    return status;
}


static int
c22xx_q_q(void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data, *sail, *text;
	struct line_type *back_line, *left_line;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	left_line = I_USER(input[0]);
	back_line = I_USER(input[1]);

	data = line_data->data;

	sail = left_line->data;
	text = back_line->data;

	data[0] = sail[0] - text[0];
	data[1] = sail[1] - text[1];
	data[2] = sail[2] - text[2];
	data[3] = sail[3] - text[3];

	l_USER(line_data, output);
    }

    return status;
}


static int
c23xx_l_m(void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data, *sail, text;
	struct line_type *left_line;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	left_line = I_USER(input[0]);

	text = I_MODE(input[1]);

	data = line_data->data;

	sail = left_line->data;

	data[0] = sail[0] + text;
	data[1] = sail[1] + text;
	data[2] = sail[2] + text;
	data[3] = sail[3] + text;
	data[4] = sail[4] + text;
	data[5] = sail[5] + text;
	data[6] = sail[6] + text;
	data[7] = sail[7] + text;

	l_USER(line_data, output);
    }

    return status;
}


static int
c23xx_p_m(void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data, *sail, text;
	struct line_type *left_line;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	left_line = I_USER(input[0]);

	text = I_MODE(input[1]);

	data = line_data->data;

	sail = left_line->data;

	data[0] = sail[0] + text;
	data[1] = sail[1] + text;

	l_USER(line_data, output);
    }

    return status;
}


static int
c23xx_q_m(void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data, *sail, text;
	struct line_type *left_line;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	left_line = I_USER(input[0]);

	text = I_MODE(input[1]);

	data = line_data->data;

	sail = left_line->data;

	data[0] = sail[0] + text;
	data[1] = sail[1] + text;
	data[2] = sail[2] + text;
	data[3] = sail[3] + text;

	l_USER(line_data, output);
    }

    return status;
}


static int
c24xx_l_m(void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data, *sail, text;
	struct line_type *left_line;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	left_line = I_USER(input[0]);

	text = I_MODE(input[1]);

	data = line_data->data;

	sail = left_line->data;

	data[0] = sail[0] - text;
	data[1] = sail[1] - text;
	data[2] = sail[2] - text;
	data[3] = sail[3] - text;
	data[4] = sail[4] - text;
	data[5] = sail[5] - text;
	data[6] = sail[6] - text;
	data[7] = sail[7] - text;

	l_USER(line_data, output);
    }

    return status;
}


static int
c24xx_p_m(void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data, *sail, text;
	struct line_type *left_line;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	left_line = I_USER(input[0]);

	text = I_MODE(input[1]);

	data = line_data->data;

	sail = left_line->data;

	data[0] = sail[0] - text;
	data[1] = sail[1] - text;

	l_USER(line_data, output);
    }

    return status;
}


static int
c24xx_q_m(void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data, *sail, text;
	struct line_type *left_line;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	left_line = I_USER(input[0]);

	text = I_MODE(input[1]);

	data = line_data->data;

	sail = left_line->data;

	data[0] = sail[0] - text;
	data[1] = sail[1] - text;
	data[2] = sail[2] - text;
	data[3] = sail[3] - text;

	l_USER(line_data, output);
    }

    return status;
}


static int
c25xx_l_p(void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data, *sail, *text;
	struct line_type *back_line, *left_line;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	left_line = I_USER(input[0]);
	back_line = I_USER(input[1]);

	data = line_data->data;

	sail = left_line->data;
	text = back_line->data;

	data[0] = sail[0] + text[0];
	data[1] = sail[1] + text[1];
	data[2] = sail[2] + text[0];
	data[3] = sail[3] + text[1];
	data[4] = sail[4] + text[0];
	data[5] = sail[5] + text[1];
	data[6] = sail[6] + text[0];
	data[7] = sail[7] + text[1];

	l_USER(line_data, output);
    }

    return status;
}


static int
c25xx_q_p(void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data, *sail, *text;
	struct line_type *back_line, *left_line;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	left_line = I_USER(input[0]);
	back_line = I_USER(input[1]);

	data = line_data->data;

	sail = left_line->data;
	text = back_line->data;

	data[0] = sail[0] + text[0];
	data[1] = sail[1] + text[1];
	data[2] = sail[2] + text[0];
	data[3] = sail[3] + text[1];

	l_USER(line_data, output);
    }

    return status;
}


static int
c26xx_l_p(void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data, *sail, *text;
	struct line_type *back_line, *left_line;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	left_line = I_USER(input[0]);
	back_line = I_USER(input[1]);

	data = line_data->data;

	sail = left_line->data;
	text = back_line->data;

	data[0] = sail[0] - text[0];
	data[1] = sail[1] - text[1];
	data[2] = sail[2] - text[0];
	data[3] = sail[3] - text[1];
	data[4] = sail[4] - text[0];
	data[5] = sail[5] - text[1];
	data[6] = sail[6] - text[0];
	data[7] = sail[7] - text[1];

	l_USER(line_data, output);
    }

    return status;
}


static int
c26xx_q_p(void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data, *sail, *text;
	struct line_type *back_line, *left_line;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	left_line = I_USER(input[0]);
	back_line = I_USER(input[1]);

	data = line_data->data;

	sail = left_line->data;
	text = back_line->data;

	data[0] = sail[0] - text[0];
	data[1] = sail[1] - text[1];
	data[2] = sail[2] - text[0];
	data[3] = sail[3] - text[1];

	l_USER(line_data, output);
    }

    return status;
}


static int
c27xx_l_q(void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data, *sail, *text;
	struct line_type *back_line, *left_line;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	left_line = I_USER(input[0]);
	back_line = I_USER(input[1]);

	data = line_data->data;

	sail = left_line->data;
	text = back_line->data;

	data[0] = sail[0] + text[0];
	data[1] = sail[1] + text[1];
	data[2] = sail[2] + text[2];
	data[3] = sail[3] + text[3];
	data[4] = sail[4] + text[0];
	data[5] = sail[5] + text[1];
	data[6] = sail[6] + text[2];
	data[7] = sail[7] + text[3];

	l_USER(line_data, output);
    }

    return status;
}


static int
c28xx_l_q(void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data, *sail, *text;
	struct line_type *back_line, *left_line;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	left_line = I_USER(input[0]);
	back_line = I_USER(input[1]);

	data = line_data->data;

	sail = left_line->data;
	text = back_line->data;

	data[0] = sail[0] - text[0];
	data[1] = sail[1] - text[1];
	data[2] = sail[2] - text[2];
	data[3] = sail[3] - text[3];
	data[4] = sail[4] - text[0];
	data[5] = sail[5] - text[1];
	data[6] = sail[6] - text[2];
	data[7] = sail[7] - text[3];

	l_USER(line_data, output);
    }

    return status;
}


static int
c77xx_l_l(void *output, void **input)
{
    long *sail, *text;
    struct line_type *back_line, *left_line;

    left_line = I_USER(input[0]);
    back_line = I_USER(input[1]);

    sail = left_line->data;
    text = back_line->data;

    sail[0] = text[0];
    sail[1] = text[1];
    sail[2] = text[2];
    sail[3] = text[3];
    sail[4] = text[4];
    sail[5] = text[5];
    sail[6] = text[6];
    sail[7] = text[7];

    l_USER(back_line, output);

    return 0;
}


static int
c77xx_p_p(void *output, void **input)
{
    long *sail, *text;
    struct line_type *back_line, *left_line;

    left_line = I_USER(input[0]);
    back_line = I_USER(input[1]);

    sail = left_line->data;
    text = back_line->data;

    sail[0] = text[0];
    sail[1] = text[1];

    l_USER(back_line, output);

    return 0;
}


static int
c77xx_q_q(void *output, void **input)
{
    long *sail, *text;
    struct line_type *back_line, *left_line;

    left_line = I_USER(input[0]);
    back_line = I_USER(input[1]);

    sail = left_line->data;
    text = back_line->data;

    sail[0] = text[0];
    sail[1] = text[1];
    sail[2] = text[2];
    sail[3] = text[3];

    l_USER(back_line, output);

    return 0;
}
