/*
 * line.0.c
 * Copyright (C) 2007-2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>

#include <aime.h>
#include <line.h>

#define I_MODE(i)			(*((X1f4_E4_C_MODE *) (i)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_USER(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

extern void *global_context;

static int back_line(void *, void *, void **);
static int back_pair(void *, void *, void **);
static int back_quad(void *, void *, void **);
static int make_line(void *, void *, void **);
static int make_pair(void *, void *, void **);
static int make_quad(void *, void *, void **);
static int pair_line(void *, void *, void **);
static int pair_quad(void *, void *, void **);
static int quad_line(void *, void *, void **);

static const int c_____l__[] = {
/* *INDENT-OFF* */
    EX20_E4_LINE
/* *INDENT-ON* */
}, c_____m_4[] = {
/* *INDENT-OFF* */
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_MODE
/* *INDENT-ON* */
}, c_____m_8[] = {
/* *INDENT-OFF* */
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_MODE,
    X1f4_E4_MODE
/* *INDENT-ON* */
}, c_____m_m[] = {
/* *INDENT-OFF* */
    X1f4_E4_MODE,
    X1f4_E4_MODE
/* *INDENT-ON* */
}, c_____p_4[] = {
/* *INDENT-OFF* */
    EX20_E4_PAIR,
    EX20_E4_PAIR,
    EX20_E4_PAIR,
    EX20_E4_PAIR
/* *INDENT-ON* */
}, c_____p__[] = {
/* *INDENT-OFF* */
    EX20_E4_PAIR
/* *INDENT-ON* */
}, c_____p_p[] = {
/* *INDENT-OFF* */
    EX20_E4_PAIR,
    EX20_E4_PAIR
/* *INDENT-ON* */
}, c_____q__[] = {
/* *INDENT-OFF* */
    EX20_E4_QUAD
/* *INDENT-ON* */
}, c_____q_q[] = {
/* *INDENT-OFF* */
    EX20_E4_QUAD,
    EX20_E4_QUAD
/* *INDENT-ON* */
};

const struct x1f4_function_type _libx1f4i0_e4_line[] = {
/* *INDENT-OFF* */
    {	"make_line",		make_line,
	EX20_E4_LINE,		c_____m_8,	8,
	0,					9		},
    {	"make_line_2",		pair_line,
	EX20_E4_LINE,		c_____p_4,	4,
	0,					11		},
    {	"make_line_4",		quad_line,
	EX20_E4_LINE,		c_____q_q,	2,
	0,					11		},
    {	"make_pair",		make_pair,
	EX20_E4_PAIR,		c_____m_m,	2,
	0,					9		},
    {	"make_quad",		make_quad,
	EX20_E4_QUAD,		c_____m_4,	4,
	0,					9		},
    {	"make_quad_2",		pair_quad,
	EX20_E4_QUAD,		c_____p_p,	2,
	0,					11		},
    {	"reverse_line",		back_line,
	EX20_E4_LINE,		c_____l__,	1,
	0,					12		},
    {	"reverse_pair",		back_pair,
	EX20_E4_PAIR,		c_____p__,	1,
	0,					12		},
    {	"reverse_quad",		back_quad,
	EX20_E4_QUAD,		c_____q__,	1,
	0,					12		},
    {	NULL,			NULL,
	0,			NULL,		0,
	0,					1		}
/* *INDENT-ON* */
};

static int
back_line(void *context, void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data, *text;
	struct line_type *back_line;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	back_line = I_USER(input[0]);

	data = line_data->data;

	text = back_line->data;

	data[0] = text[7];
	data[1] = text[6];
	data[2] = text[5];
	data[3] = text[4];
	data[4] = text[3];
	data[5] = text[2];
	data[6] = text[1];
	data[7] = text[0];

	l_USER(line_data, output);
    }

    return status;
}


static int
back_pair(void *context, void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data, *text;
	struct line_type *back_line;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	back_line = I_USER(input[0]);

	data = line_data->data;

	text = back_line->data;

	data[0] = text[1];
	data[1] = text[0];

	l_USER(line_data, output);
    }

    return status;
}


static int
back_quad(void *context, void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data, *text;
	struct line_type *back_line;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	back_line = I_USER(input[0]);

	data = line_data->data;

	text = back_line->data;

	data[0] = text[3];
	data[1] = text[2];
	data[2] = text[1];
	data[3] = text[0];

	l_USER(line_data, output);
    }

    return status;
}


static int
make_line(void *context, void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	data = line_data->data;

	data[0] = I_MODE(input[0]);
	data[1] = I_MODE(input[1]);
	data[2] = I_MODE(input[2]);
	data[3] = I_MODE(input[3]);
	data[4] = I_MODE(input[4]);
	data[5] = I_MODE(input[5]);
	data[6] = I_MODE(input[6]);
	data[7] = I_MODE(input[7]);

	l_USER(line_data, output);
    }

    return status;
}


static int
make_pair(void *context, void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	data = line_data->data;

	data[0] = I_MODE(input[0]);
	data[1] = I_MODE(input[1]);

	l_USER(line_data, output);
    }

    return status;
}


static int
make_quad(void *context, void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	data = line_data->data;

	data[0] = I_MODE(input[0]);
	data[1] = I_MODE(input[1]);
	data[2] = I_MODE(input[2]);
	data[3] = I_MODE(input[3]);

	l_USER(line_data, output);
    }

    return status;
}


static int
pair_line(void *context, void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data, *text;
	struct line_type *text_line;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	data = line_data->data;

	text_line = I_USER(input[0]);

	text = text_line->data;

	data[0] = text[0];
	data[1] = text[1];

	text_line = I_USER(input[1]);

	text = text_line->data;

	data[2] = text[0];
	data[3] = text[1];

	text_line = I_USER(input[2]);

	text = text_line->data;

	data[4] = text[0];
	data[5] = text[1];

	text_line = I_USER(input[3]);

	text = text_line->data;

	data[6] = text[0];
	data[7] = text[1];

	l_USER(line_data, output);
    }

    return status;
}


static int
pair_quad(void *context, void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data, *text;
	struct line_type *text_line;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	data = line_data->data;

	text_line = I_USER(input[0]);

	text = text_line->data;

	data[0] = text[0];
	data[1] = text[1];

	text_line = I_USER(input[1]);

	text = text_line->data;

	data[2] = text[0];
	data[3] = text[1];

	l_USER(line_data, output);
    }

    return status;
}


static int
quad_line(void *context, void *output, void **input)
{
    int status;
    struct line_type *line_data;

    line_data = (struct line_type *) malloc(sizeof(struct line_type));
    if (!line_data) {
	status = -1;
    } else {
	long *data, *text;
	struct line_type *text_line;
	struct miss_type *miss_data;

	status = 0;

	miss_data = global_context;

	line_data->line_data = miss_data->line_data;
	miss_data->line_data = line_data;

	data = line_data->data;

	text_line = I_USER(input[0]);

	text = text_line->data;

	data[0] = text[0];
	data[1] = text[1];
	data[2] = text[2];
	data[3] = text[3];

	text_line = I_USER(input[1]);

	text = text_line->data;

	data[4] = text[0];
	data[5] = text[1];
	data[6] = text[2];
	data[7] = text[3];

	l_USER(line_data, output);
    }

    return status;
}
