/*
 * lead.0.c
 * Copyright (C) 2011-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <unistd.h>

#include <aime.h>

#define I_MODE(i)			(*((X1f4_E4_C_MODE *) (i)))

static int lead_1601(void *, void *, void **);
static int lead_1602(void *, void *, void **);

static const int c_____m__[] = {
/* *INDENT-OFF* */
    X1f4_E4_MODE
/* *INDENT-ON* */
};
const struct x1f4_function_type _libx1f4i0_lead_0[] = {
/* *INDENT-OFF* */
    {	"sleep",		lead_1601,
	X1f4_E4_VOID,		c_____m__,	1,
	X1f4_E4_KEEP_CALL,			5		},
    {	"usleep",		lead_1602,
	X1f4_E4_VOID,		c_____m__,	1,
	X1f4_E4_KEEP_CALL,			6		},
    {	NULL,			NULL,
	0,			NULL,		0,
	0,					1		}
/* *INDENT-ON* */
};

static int
lead_1601(void *context, void *output, void **input)
{
    X1f4_E4_C_MODE mode;

    mode = I_MODE(input[0]);
    if (0 < mode) {
	sleep(mode);
    }

    return 0;
}


static int
lead_1602(void *context, void *output, void **input)
{
    X1f4_E4_C_MODE mode;

    mode = I_MODE(input[0]);
    if (0 < mode) {
	usleep(mode);
    }

    return 0;
}
