/*
 * last.0.c
 * Copyright (C) 2002-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <aime.h>

int
libx1f4i0_select_function(const char *f, unsigned length, const void *context,
			  const struct x1f4_function_type **function)
{
    int status = X1f4_E4_PARSE_ERROR;
    const struct x1f4_function_type *function_data;

    function_data = context;
    if (function_data) {
	while (function_data->name) {
	    if (length == function_data->length
		&& !memcmp((void *) f, function_data->name, length)) {
		break;
	    }
	    function_data++;
	}
	if (function_data->name) {
	    status = 0;
	    *function = function_data;
	}
    }

    return status;
}
