/*
 * fine.1.c
 * Copyright (C) 2006-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <aime.h>
#if !defined HAVE_LIBx1f4i0
# include <ckeytree.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <inter.h>
#if !defined HAVE_LIBx1f4i0
# include <ordinal.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <types.h>

static const struct x1f4_ckeytree_type type_0[] = {
/* *INDENT-OFF* */
    {	"cardinal",	{	X1f4_E4_BILL	},	NULL	},
    {	"integer",	{	X1f4_E4_MODE	},	NULL	},
    {	"real",		{	X1f4_E4_REAL	},	NULL	},
    {	"text",		{	X1f4_E4_TEXT	},	NULL	},
    {	NULL,		{	0		},	NULL	}
/* *INDENT-ON* */
}, type_root[] = {
/* *INDENT-OFF* */
    {	"",		{	0		},	type_0	},
    {	NULL,		{	0		},	NULL	}
/* *INDENT-ON* */
};

int
libx1f4i0_init_fine(int optind, int argc, char **argv, unsigned *Count,
		    void **state, void **context)
{
    int status;
    struct lead_type *state_data;
    unsigned count;

    count = (argc - optind) / 3;
    if (!count) {
	status = 0;
	state_data = NULL;
    } else {
	state_data = (struct lead_type *)
	    malloc(sizeof(struct lead_type) * count);
	if (!state_data) {
	    status = 1;
	} else {
	    char **list;
	    struct lead_type *slide3;
	    unsigned i;

	    list = argv + optind + 1;

	    slide3 = state_data;

	    for (i = count; i; i--) {
		char *name;
		int status;
		unsigned type;

		status = x1f4_find_ctkey(argv[optind], type_root, &type);
		if (status) {
		    char sx[3];

		    x1f4_extend_ordinal(sx, i);
		    sx[2] = 0;
		    fprintf(stderr, "%s: cannot parse type specification for"
			    " %u%s variable: `%s'\n", argv[0], count - i + 1,
			    sx, argv[optind]);

		    break;
		}

		optind++;

		name = argv[optind];

		if (x1f4_check_identifier(name)) {
		    char sx[3];

		    x1f4_extend_ordinal(sx, count - i);
		    sx[2] = 0;
		    fprintf(stderr, "%s: invalid name for %u%s variable: `%s"
			    "'\n", argv[0], count - i + 1, sx, name);

		    break;
		}

		optind++;

		if (type == X1f4_E4_BILL) {
		    status = libx1f4i0_lead_bill
			(argv[0], argv[optind], count - i, slide3);
		    if (status) {
			break;
		    }

		    status = x1f4_push_bill
			(context, name, strlen(name), 0, slide3);
		} else if (type == X1f4_E4_MODE) {
		    status = libx1f4i0_lead_mode
			(argv[0], argv[optind], count - i, slide3);
		    if (status) {
			break;
		    }

		    status = x1f4_push_mode
			(context, name, strlen(name), 0, slide3);
		} else if (type == X1f4_E4_REAL) {
		    status = libx1f4i0_lead_real
			(argv[0], argv[optind], count - i, slide3);
		    if (status) {
			break;
		    }

		    status = x1f4_push_real
			(context, name, strlen(name), 0, slide3);
		} else {
		    X1f4_E4_C_TEXT *storage;

		    storage = (void *) slide3;
		    *storage = argv[optind];
		    status = x1f4_push_text
			(context, name, strlen(name), 0, slide3);
		}

		if (status) {
		    if (status == X1f4_CV_ALLOC_ERROR) {
			perror(argv[0]);
			break;
		    } else {
			char sx[3];

			x1f4_extend_ordinal(sx, count - i);
			sx[2] = 0;
			fprintf(stderr, "%s: duplicate name for %u%s variab"
				"le: `%s'\n", argv[0], count - i + 1, sx,
				name);

			break;
		    }
		}

		optind++;

		slide3++;
	    }
	    if (i) {
		status = 1;
	    } else {
		status = 0;
	    }
	}
    }

    *Count = count;

    *state = state_data;

    return status;
}
