/*
 * data.8.c
 * Copyright (C) 2006-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>

int
libx1f4i0_free_data(void *context, void *data)
{
    free(data);

    return 0;
}


int
libx1f4i0_link_data(void *context, void **link, unsigned size)
{
    int status = 0;
    void *data;

    data = malloc(size);
    if (!data) {
	status = -1;
    } else {
	*link = data;
    }

    return status;
}


int
libx1f4i0_mode_data(void *context, void **link, unsigned size)
{
    int status = 0;
    void *data;

    data = realloc(*link, size);
    if (!data) {
	status = -1;
    } else {
	*link = data;
    }

    return status;
}
