/*
 * data.1.c
 * Copyright (C) 2006-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */

#include <aime.h>
#if !defined HAVE_LIBx1f4i0
# include <float1.h>
# include <lcardinal.f.h>
# include <lintegral.f.h>
#endif				/* !HAVE_LIBx1f4i0 */

#define I_BILL(i)			(*((X1f4_E4_C_BILL *) (i)))
#define I_MODE(i)			(*((X1f4_E4_C_MODE *) (i)))
#define I_REAL(r)			(*((X1f4_E4_C_REAL *) (r)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

int
libx1f4i0_type_data(int type, unsigned precision, void *data)
{
    if (type == X1f4_E4_BILL) {
	x1f4_fprint_lcardinal(stdout, 0, 10, I_BILL(data));
    } else {
	if (type == X1f4_E4_MODE) {
	    x1f4_fprint_lintegral(stdout, 0, 10, I_MODE(data));
	} else {
	    if (type == X1f4_E4_TEXT) {
		printf("%s", I_TEXT(data));
	    } else {
		if (type == X1f4_E4_REAL) {
		    x1f4_fprint_wfloat(stdout, 0, 0, precision, I_REAL(data));
		}
	    }
	}
    }

    putchar('\n');

    return 0;
}
