/*
 * dash.c
 * Copyright (C) 2011-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <defs.h>

int
libx1f4i0_read_dash(void **data, unsigned *size, unsigned extra)
{
    char *text;
    int fd = STDIN_FILENO, status = 0;
    unsigned head = 0, slip = 2047;

    text = malloc(slip + extra);
    if (text) {
	while (1) {
	    status = read(fd, text + head, slip - head);
	    if (status < 0) {
		status = LIBx1f4i0_READ_FAILURE;
		if (1) {
		    break;
		}
	    } else {
		if (status) {
		    head += status;
		    if (head == slip) {
			char *ways;

			slip <<= 1;
			slip |= 1;
			ways = realloc(text, slip + extra);
			if (ways) {
			    text = ways;
			} else {
			    status = LIBx1f4i0_LACK_FAILURE;
			    if (1) {
				break;
			    }
			}
		    }
		} else {
		    *data = text;
		    if (size) {
			*size = head;
		    }

		    break;
		}
	    }
	}
    } else {
	status = LIBx1f4i0_LACK_FAILURE;
    }

    if (status) {
	if (text) {
	    free(text);
	}
    }

    return status;
}
