/*
 * aime.h
 * Copyright (C) 2002, 2003, 2004, 2005, 2006, 2007, 2008, Ciprian Niculescu
 * Copyright (C) 2009, 2010, 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __x1f4_aime_H__
#define __x1f4_aime_H__

#include <stddef.h>
#include <stdio.h>
#include <unistd.h>

#include <sys/types.h>

/*
 * a1 error definitions
 */
#define X1f4_A1_ALLOC_ERROR		1
#define X1f4_A1_PARSE_ERROR		2

/*
 * a1 generation flag definitions
 */
#define X1f4_A1_BCOLLECT		(1L << 0x00)
#define X1f4_A1_CASTTYPE		(1L << 0x01)
#define X1f4_A1_COMPOSER		(1L << 0x02)
#define X1f4_A1_DDACCESS		(1L << 0x03)
#define X1f4_A1_EELOOKUP		(1L << 0x04)
#define X1f4_A1_IMPLICIT		(1L << 0x06)
#define X1f4_A1_LEADCAST		(1L << 0x07)
#define X1f4_A1_OPTIMIZE		(1L << 0x08)
#define X1f4_A1_RESOURCE		(1L << 0x09)
#define X1f4_A1_SCOMMENT		(1L << 0x0a)
#define X1f4_A1_SIDELIST		(1L << 0x0b)
#define X1f4_A1_TEXTFLAT		(1L << 0x0c)
#define X1f4_A1_TRANSFER		(1L << 0x0d)
#define X1f4_A1_TYPELIST		(1L << 0x0e)

/*
 * a1 parse error definitions
 */
#define X1f4_A1_C_SYNTAX		-129
#define X1f4_A1_FAILLINK		-130
#define X1f4_A1_FAILLIST		-131
#define X1f4_A1_FAILNAME		-132
#define X1f4_A1_FAILPOST		-133
#define X1f4_A1_FAILTYPE		-134
#define X1f4_A1_FLATTYPE		-135
#define X1f4_A1_HIGHEROF		-136
#define X1f4_A1_LASTLIST		-137
#define X1f4_A1_LESSLINK		-138
#define X1f4_A1_LINKNODE		-139
#define X1f4_A1_LOSELIST		-140
#define X1f4_A1_LOSETEXT		-141
#define X1f4_A1_MAINLIST		-142
#define X1f4_A1_MAINTYPE		-143
#define X1f4_A1_MISSLEAD		-144
#define X1f4_A1_MISSLINE		-145
#define X1f4_A1_MISSLINK		-146
#define X1f4_A1_MISSLIST		X1f4_A1_MISSTYPE
#define X1f4_A1_MISSMAIN		-147
#define X1f4_A1_MISSNAME		-148
#define X1f4_A1_MISSPOST		X1f4_A1_MISSTYPE
#define X1f4_A1_MISSTYPE		-149
#define X1f4_A1_NEARTYPE		-150
#define X1f4_A1_OPENLIST		-151
#define X1f4_A1_OPENTEXT		-152
#define X1f4_A1_POSTFEAT		-153
#define X1f4_A1_RESERVED		-154
#define X1f4_A1_SIDELINE		-155
#define X1f4_A1_VOIDPOST		-156
#define X1f4_A1_XDEFINED		-157

/*
 * a1 parse error definitions (continued)
 */
#define X1f4_A1_INTERNAL		-896

/*
 * a1 record definitions
 */
#define X1f4_A1_HINT_MASK		(1L << 0x00)

/*
 * c1 completion definitions
 */
#define X1f4_C1_BACK_COMPLETION		0
#define X1f4_C1_BYTE_COMPLETION		1
#define X1f4_C1_TURN_COMPLETION		2

/*
 * c1 error definitions
 */
#define X1f4_C1_ALLOC_ERROR		1
#define X1f4_C1_PARSE_ERROR		2

/*
 * c1 generation flag definitions
 */
#define X1f4_C1_BCOLLECT		(1L << 0x00)
#define X1f4_C1_COMPOSER		(1L << 0x01)
#define X1f4_C1_DDACCESS		(1L << 0x02)
#define X1f4_C1_IMPLICIT		(1L << 0x04)
#define X1f4_C1_LEADPOST		(1L << 0x05)
#define X1f4_C1_OPTIMIZE		(1L << 0x06)
#define X1f4_C1_RESOURCE		(1L << 0x07)
#define X1f4_C1_SCOMMENT		(1L << 0x08)
#define X1f4_C1_SIDELIST		(1L << 0x09)
#define X1f4_C1_SLIPTEST		(1L << 0x0a)
#define X1f4_C1_TRANSFER		(1L << 0x0b)
#define X1f4_C1_TURNCAST		(1L << 0x0c)
#define X1f4_C1_TYPELIST		(1L << 0x0d)

/*
 * c1 parse error definitions
 */
#define X1f4_C1_BLOCKOUT		-129
#define X1f4_C1_B_SYNTAX		-130
#define X1f4_C1_COMPLETE		-131
#define X1f4_C1_E_RETURN		-132
#define X1f4_C1_E_SYNTAX		-133
#define X1f4_C1_HIGHEROF		-134
#define X1f4_C1_LINKNODE		-135
#define X1f4_C1_LOOPEXIT		-136
#define X1f4_C1_LOOSE_DB		-137
#define X1f4_C1_L_SCOPES		-138
#define X1f4_C1_MISSLOOP		-139
#define X1f4_C1_MISSTEST		-140
#define X1f4_C1_M_RETURN		-141
#define X1f4_C1_NAMEMISS		-142
#define X1f4_C1_OUTBREAK		-143
#define X1f4_C1_RESERVED		-144
#define X1f4_C1_SIDEDATA		-145
#define X1f4_C1_S_SYNTAX		-146
#define X1f4_C1_T_SYNTAX		-147
#define X1f4_C1_USEDVOID		-148
#define X1f4_C1_VARIABLE		-149
#define X1f4_C1_W_SCALAR		-150
#define X1f4_C1_X_RETURN		-151

/*
 * c1 record definitions
 */
#define X1f4_C1_HINT_MASK		(1L << 0x00)

/*
 * common data type flag definitions
 */
#define X1f4_LX_LINK_ACCESS		(1L << 1)
#define X1f4_LX_PICK_ACCESS		(1L << 2)
#define X1f4_LX_POST_ACCESS		(1L << 3)
#define X1f4_LX_PULL_ACCESS		(1L << 4)

/*
 * common data type flag definitions (continued)
 */
#define X1f4_LX_AUTO_RECORD		(1L << 7)

/*
 * common data type flag definitions (no longer used)
 */
#define X1f4_LX_MISS_APPEND		0
#define X1f4_LX_MISS_INSERT		0
#define X1f4_LX_MISS_OFFSET		0
#define X1f4_LX_MISS_RECORD		0
#define X1f4_LX_MISS_SWITCH		0

/*
 * e2list error definitions
 */
#define X1f4_E2LIST_CALL_ERROR		-1
#define X1f4_E2LIST_FREE_ERROR		-2
#define X1f4_E2LIST_LINK_ERROR		-3
#define X1f4_E2LIST_MODE_ERROR		-4

/*
 * e2list generation flag definitions
 */
#define X1f4_E2LIST_FLATLINE		(1L << 0)
#define X1f4_E2LIST_MISSLINK		(1L << 1)
#define X1f4_E2LIST_RESOURCE		(1L << 2)

/*
 * e4fine generation flag definitions
 */
#define X1f4_E4FINE_RESOURCE		(1L << 0)

/*
 * e4ll error definitions
 */
#define X1f4_E4LL_DECK_ERROR		-1
#define X1f4_E4LL_FINI_ERROR		-2
#define X1f4_E4LL_FREE_ERROR		-3
#define X1f4_E4LL_INIT_ERROR		-4
#define X1f4_E4LL_LINK_ERROR		-5
#define X1f4_E4LL_MODE_ERROR		-6
#define X1f4_E4LL_SWAP_ERROR		-7

/*
 * e4ll generation flag definitions
 */
#define X1f4_E4LL_MISSLINK		(1L << 0)
#define X1f4_E4LL_RESOURCE		(1L << 1)
#define X1f4_E4LL_TEXTFLAT		(1L << 2)

/*
 * e4 C type definitions
 */
#define X1f4_E4_C_BILL			unsigned long
#define X1f4_E4_C_MODE			long
#define X1f4_E4_C_REAL			double
#define X1f4_E4_C_TEXT			char *
#define X1f4_E4_C_USER			void *

/*
 * e4 completion definitions
 */
#define X1f4_E4_BACK_COMPLETION		0
#define X1f4_E4_BYTE_COMPLETION		1

/*
 * e4 error definitions
 */
#define X1f4_E4_ALLOC_ERROR		1
#define X1f4_E4_PARSE_ERROR		2

/*
 * e4 function parameter flag definition
 */
#define X1f4_E4_POST_XSET		(1 << 0x00)

/*
 * e4 function flag definitions
 */
#define X1f4_E4_LINK_PASS		(1L << 0x02)
#define X1f4_E4_POST_TYPE		(1L << 0x03)
#define X1f4_E4_SIDE_LIST		(1L << 0x04)
#define X1f4_E4_SLIP_LIST		(1L << 0x05)
#define X1f4_E4_TEXT_LINK		(1L << 0x06)
#define X1f4_E4_WALK_LINK		(1L << 0x07)

/*
 * e4 function flag definitions (concluded)
 */
#define X1f4_E4_FUNCTION_LAST		X1f4_E4_WALK_LINK

/*
 * e4 generation flag definitions
 */
#define X1f4_E4_BCOLLECT		(1L << 0x00)
#define X1f4_E4_COMPOSER		(1L << 0x01)
#define X1f4_E4_DDACCESS		(1L << 0x02)
#define X1f4_E4_ESTORAGE		(1L << 0x03)
#define X1f4_E4_IMPLICIT		(1L << 0x04)
#define X1f4_E4_MAXSTACK		(1L << 0x05)
#define X1f4_E4_RESOURCE		(1L << 0x06)
#define X1f4_E4_SCOMMENT		(1L << 0x07)
#define X1f4_E4_SEQUENCE		(1L << 0x08)
#define X1f4_E4_SLIPTEST		(1L << 0x09)
#define X1f4_E4_TRANSFER		(1L << 0x0a)

/*
 * e4 infix bynary operator flag definitions
 */
#define X1f4_E4_BACK_LINK		(1L << 0x03)
#define X1f4_E4_CALL_XSET		(1L << 0x04 | X1f4_E4_LEFT_XSET)
#define X1f4_E4_LEFT_LAST		(1L << 0x05)
#define X1f4_E4_LEFT_XSET		(1L << 0x06)

/*
 * e4 operator 1st entension flag definitions
 */
#define X1f4_E4_LEFT_FILL		(1L << 0x04)
#define X1f4_E4_LEFT_KILL		(1L << 0x05)
#define X1f4_E4_LEFT_SKIP		(1L << 0x06)
#define X1f4_E4_MXAA_LIST		(1L << 0x08)
#define X1f4_E4_MXAC_LIST		(1L << 0x09)
#define X1f4_E4_MXAS_LIST		(1L << 0x0a)
#define X1f4_E4_MXCA_LIST		(1L << 0x0b)
#define X1f4_E4_MXCC_LIST		(1L << 0x0c)
#define X1f4_E4_MXCS_LIST		(1L << 0x0d)
#define X1f4_E4_NXAA_LIST		(1L << 0x0e)
#define X1f4_E4_NXAC_LIST		(1L << 0x0f)
#define X1f4_E4_NXCA_LIST		(1L << 0x10)
#define X1f4_E4_NXCC_LIST		(1L << 0x11)
#define X1f4_E4_POST_FLOW		(1L << 0x12)
#define X1f4_E4_POST_KILL		(1L << 0x13)
#define X1f4_E4_POST_SKIP		(1L << 0x14)

/*
 * e4 operator 2nd entension flag definitions
 */
#define X1f4_E4_CALL_LINK		(1L << 0x00)
#define X1f4_E4_RANK_LIST		(1L << 0x01)
#define X1f4_E4_RANK_NONE		(1L << 0x02)

/*
 * e4 operator and function flag definitions
 */
#define X1f4_E4_KEEP_CALL		(1L << 0x00)

/*
 * e4 operator flag definitions
 */
#define X1f4_E4_E1ST_LINK		(1L << 0x01)
#define X1f4_E4_E2ND_LINK		(1L << 0x02)

/*
 * e4 parse error definitions
 */
#define X1f4_E4_BINARY_R		-129
#define X1f4_E4_BYTEMISS		-130
#define X1f4_E4_B_LOOKUP		-131
#define X1f4_E4_B_SCALAR		-132
#define X1f4_E4_C_LVALUE		-133
#define X1f4_E4_C_STRING		-134
#define X1f4_E4_EXPECTED		-135
#define X1f4_E4_E_SYNTAX		-138
#define X1f4_E4_F_LOOKUP		-141
#define X1f4_E4_F_SYNTAX		-142
#define X1f4_E4_I_LVALUE		-139
#define X1f4_E4_LONGVOID		-140
#define X1f4_E4_MISSCALL		-143
#define X1f4_E4_MISSTURN		-144
#define X1f4_E4_MISSTYPE		-145
#define X1f4_E4_NEARCITE		-146
#define X1f4_E4_NEARJOIN		-147
#define X1f4_E4_NEARLOSE		-148
#define X1f4_E4_NEARNAME		-149
#define X1f4_E4_NEAROPEN		-150
#define X1f4_E4_NEARREAL		-151
#define X1f4_E4_NEARSTEP		-152
#define X1f4_E4_NEARTEXT		-153
#define X1f4_E4_NEARVOID		-154
#define X1f4_E4_P_LOOKUP		-155
#define X1f4_E4_R_SCALAR		-156
#define X1f4_E4_SURELOSE		-157
#define X1f4_E4_SURESTEP		-158
#define X1f4_E4_USEDVOID		-159
#define X1f4_E4_U_BINARY		-160
#define X1f4_E4_U_PREFIX		-161
#define X1f4_E4_V_LOOKUP		-136
#define X1f4_E4_V_SYNTAX		-137

/*
 * e4 parse error definitions (continued)
 */
#define X1f4_E4_C_SVALUE		-162
#define X1f4_E4_I_SVALUE		-163
#define X1f4_E4_T_SVALUE		-164

/*
 * e4 parse error definitions (concluded)
 */
#define X1f4_E4_C_SYNTAX		-165

/*
 * e4 prefix unary operator flag definitions
 */
#define X1f4_E4_KILL_PAIR		(1L << 0x03)
#define X1f4_E4_LOSE_DATA		(1L << 0x04)
#define X1f4_E4_MISS_PAIR		(1L << 0x05)

/*
 * e4 printing flag definitions
 */
#define X1f4_E4_DETAIL_CONSTANTS	(1L << 0x00)
#define X1f4_E4_DETAIL_IMPLICITS	(1L << 0x01)
#define X1f4_E4_DETAIL_OPERATORS	(1L << 0x02)

/*
 * e4 type definitions
 */
#define X1f4_E4_BILL			0
#define X1f4_E4_MODE			1
#define X1f4_E4_REAL			2
#define X1f4_E4_TEXT			3

/*
 * e4 type definitions (continued)
 */
#define X1f4_E4_SLIP			4095

/*
 * e4 type definitions (continued)
 */
#define X1f4_E4_VOID			4096

/*
 * type definitions (continued)
 */
#define X1f4_E4_LAST			8192

/*
 * type definitions (concluded)
 */
#define X1f4_E4_CALL			131072

/*
 * e4 variable flag definitions
 */
#define X1f4_E4_READ_ONLY		(1L << 0x00)
#define X1f4_E4_REFERENCE		(1L << 0x01)

/*
 * e4 zero element promotion flag definitions
 */
#define X1f4_E4_RDBX_LESS_NONE		(1L << 0)
#define X1f4_E4_RDBX_MISS_TYPE		(1L << 1)

/*
 * error classification definitions
 */
#define X1f4_EX_CAN_CONTINUE		-74880
#define X1f4_EX_CRITICAL		-74881
#define X1f4_EX_CANNOT_CONTINUE		-74882

/*
 * lxbail error definitions
 */
#define X1f4_LXBAIL_FREE_ERROR		-2
#define X1f4_LXBAIL_LINK_ERROR		-3
#define X1f4_LXBAIL_MODE_ERROR		-4

/*
 * lxbail generation flag definitions
 */
#define X1f4_LXBAIL_RESOURCE		(1L << 1)
#define X1f4_LXBAIL_TEXTFLAT		(1L << 2)

/*
 * lxcast error definitions
 */
#define X1f4_LXCAST_FREE_ERROR		-2
#define X1f4_LXCAST_LINK_ERROR		-3
#define X1f4_LXCAST_MODE_ERROR		-4

/*
 * lxcast generation flag definitions
 */
#define X1f4_LXCAST_CODELINK		(1L << 0)
#define X1f4_LXCAST_EELOOKUP		(1L << 1)
#define X1f4_LXCAST_RESOURCE		(1L << 2)
#define X1f4_LXCAST_TEXTFLAT		(1L << 3)
#define X1f4_LXCAST_TRANSFER		(1L << 4)

/*
 * lxdata error definitions
 */
#define X1f4_LXDATA_FREE_ERROR		-2
#define X1f4_LXDATA_LINK_ERROR		-3
#define X1f4_LXDATA_MODE_ERROR		-4

/*
 * lxdata generation flag definitions
 */
#define X1f4_LXDATA_CODELINK		(1L << 0)
#define X1f4_LXDATA_EVERLINK		(1L << 1)
#define X1f4_LXDATA_RESOURCE		(1L << 2)
#define X1f4_LXDATA_TEXTFLAT		(1L << 3)

/*
 * lxdate error definitions
 */
#define X1f4_LXDATE_FREE_ERROR		-2
#define X1f4_LXDATE_LINK_ERROR		-3
#define X1f4_LXDATE_MODE_ERROR		-4

/*
 * lxdate generation flag definitions
 */
#define X1f4_LXDATE_CODELINK		(1L << 0)
#define X1f4_LXDATE_EVERLINK		(1L << 1)
#define X1f4_LXDATE_RESOURCE		(1L << 2)
#define X1f4_LXDATE_TEXTFLAT		(1L << 3)

/*
 * lxdecq error definitions
 */
#define X1f4_LXDECQ_FREE_ERROR		-2
#define X1f4_LXDECQ_LINK_ERROR		-3
#define X1f4_LXDECQ_MODE_ERROR		-4

/*
 * lxdecq generation flag definitions
 */
#define X1f4_LXDECQ_CODELINK		(1L << 0)
#define X1f4_LXDECQ_EELOOKUP		(1L << 1)
#define X1f4_LXDECQ_EVERLINK		(1L << 2)
#define X1f4_LXDECQ_MISSBAIL		(1L << 3)
#define X1f4_LXDECQ_RESETNEW		(1L << 4)
#define X1f4_LXDECQ_RESOURCE		(1L << 5)
#define X1f4_LXDECQ_TEXTFLAT		(1L << 6)

/*
 * lxfile error definitions
 */
#define X1f4_LXFILE_FREE_ERROR		-2
#define X1f4_LXFILE_LINK_ERROR		-3
#define X1f4_LXFILE_MODE_ERROR		-4

/*
 * lxfile generation flag definitions
 */
#define X1f4_LXFILE_CODELINK		(1L << 0)
#define X1f4_LXFILE_DATALINK		(1L << 1)
#define X1f4_LXFILE_EVERLINK		(1L << 2)
#define X1f4_LXFILE_LISTLINK		(1L << 3)
#define X1f4_LXFILE_RESOURCE		(1L << 4)
#define X1f4_LXFILE_SETCLOSE		(1L << 5)
#define X1f4_LXFILE_TEXTFLAT		(1L << 6)

/*
 * lxflat error definitions
 */
#define X1f4_LXFLAT_FREE_ERROR		-2
#define X1f4_LXFLAT_LINK_ERROR		-3
#define X1f4_LXFLAT_MODE_ERROR		-4

/*
 * lxflat generation flag definitions
 */
#define X1f4_LXFLAT_ABSTRACT		(1L << 0)
#define X1f4_LXFLAT_CODELINK		(1L << 1)
#define X1f4_LXFLAT_RESOURCE		(1L << 2)
#define X1f4_LXFLAT_TEXTFLAT		(1L << 3)

/*
 * lxfset error definitions
 */
#define X1f4_LXFSET_EVER_MATCH		X1f4_I0CLIP_EVER_MATCH

/*
 * lxline error definitions
 */
#define X1f4_LXLINE_FREE_ERROR		-2
#define X1f4_LXLINE_LINK_ERROR		-3
#define X1f4_LXLINE_MODE_ERROR		-4

/*
 * lxline generation flag definitions
 */
#define X1f4_LXLINE_CASTTYPE		(1L << 0)
#define X1f4_LXLINE_CODELINK		(1L << 1)
#define X1f4_LXLINE_EELOOKUP		(1L << 2)
#define X1f4_LXLINE_EVERLINK		(1L << 3)
#define X1f4_LXLINE_MISSBAIL		(1L << 4)
#define X1f4_LXLINE_RESETNEW		(1L << 5)
#define X1f4_LXLINE_RESOURCE		(1L << 6)
#define X1f4_LXLINE_TEXTFLAT		(1L << 7)
#define X1f4_LXLINE_TRANSFER		(1L << 8)

/*
 * lxlist error definitions
 */
#define X1f4_LXLIST_FREE_ERROR		-2
#define X1f4_LXLIST_LINK_ERROR		-3
#define X1f4_LXLIST_MODE_ERROR		-4

/*
 * lxlist generation flag definitions
 */
#define X1f4_LXLIST_AUTOLINK		(1L << 0)
#define X1f4_LXLIST_CASTTYPE		(1L << 1)
#define X1f4_LXLIST_CODELINK		(1L << 2)
#define X1f4_LXLIST_EELOOKUP		(1L << 3)
#define X1f4_LXLIST_EVERLINK		(1L << 4)
#define X1f4_LXLIST_MISSBAIL		(1L << 5)
#define X1f4_LXLIST_RESETNEW		(1L << 6)
#define X1f4_LXLIST_RESOURCE		(1L << 7)
#define X1f4_LXLIST_TEXTFLAT		(1L << 8)
#define X1f4_LXLIST_TRANSFER		(1L << 9)

/*
 * lxmath error definitions
 */
#define X1f4_LXMATH_FREE_ERROR		-2
#define X1f4_LXMATH_LINK_ERROR		-3
#define X1f4_LXMATH_MODE_ERROR		-4

/*
 * lxmath generation flag definitions
 */
#define X1f4_LXMATH_CODELINK		(1L << 0)
#define X1f4_LXMATH_TEXTFLAT		(1L << 1)

/*
 * lxnear error definitions
 */
#define X1f4_LXNEAR_FREE_ERROR		-2
#define X1f4_LXNEAR_LINK_ERROR		-3
#define X1f4_LXNEAR_MODE_ERROR		-4

/*
 * lxnear generation flag definitions
 */
#define X1f4_LXNEAR_CASTTYPE		(1L << 0)
#define X1f4_LXNEAR_CODELINK		(1L << 1)
#define X1f4_LXNEAR_LONGPIPE		(1L << 2)
#define X1f4_LXNEAR_TEXTFLAT		(1L << 3)
#define X1f4_LXNEAR_TRANSFER		(1L << 4)

/*
 * lxport error definitions
 */
#define X1f4_LXPORT_FREE_ERROR		-2
#define X1f4_LXPORT_LINK_ERROR		-3
#define X1f4_LXPORT_MODE_ERROR		-4

/*
 * lxport forked standard error definitions
 */
#define X1f4_LXPORT_LOSE_C3RD		1
#define X1f4_LXPORT_NULL_C3RD		2
#define X1f4_LXPORT_MISS_C3RD		3

/*
 * lxport generation flag definitions
 */
#define X1f4_LXPORT_CODELINK		(1L << 0)
#define X1f4_LXPORT_EVERLINK		(1L << 1)
#define X1f4_LXPORT_MISSBAIL		(1L << 2)
#define X1f4_LXPORT_RESOURCE		(1L << 3)
#define X1f4_LXPORT_SETCLOSE		(1L << 4)
#define X1f4_LXPORT_SHUTLINE		(1L << 5)
#define X1f4_LXPORT_TEXTFLAT		(1L << 6)
#define X1f4_LXPORT_THIRDSET		(1L << 7)

/*
 * lxtext error definitions
 */
#define X1f4_LXTEXT_FREE_ERROR		-2
#define X1f4_LXTEXT_LINK_ERROR		-3
#define X1f4_LXTEXT_MODE_ERROR		-4

/*
 * lxtext generation flag definitions
 */
#define X1f4_LXTEXT_CODELINK		(1L << 0)
#define X1f4_LXTEXT_RESOURCE		(1L << 1)
#define X1f4_LXTEXT_TEXTFLAT		(1L << 2)

/*
 * lxtrap error definitions
 */
#define X1f4_LXTRAP_FREE_ERROR		-2
#define X1f4_LXTRAP_LINK_ERROR		-3
#define X1f4_LXTRAP_MODE_ERROR		-4

/*
 * lxtrap generation flag definitions
 */
#define X1f4_LXTRAP_CODELINK		(1L << 0)
#define X1f4_LXTRAP_COMPOSER		(1L << 1)
#define X1f4_LXTRAP_EELOOKUP		(1L << 2)
#define X1f4_LXTRAP_IMPLICIT		(1L << 3)
#define X1f4_LXTRAP_RESOURCE		(1L << 4)
#define X1f4_LXTRAP_TEXTFLAT		(1L << 5)

/*
 * lxwide flag definitions
 */
#define X1f4_LXWIDE_CASTTYPE		(1L << 0x03)
#define X1f4_LXWIDE_CODELINK		(1L << 0x04)
#define X1f4_LXWIDE_MISSBAIL		(1L << 0x05)
#define X1f4_LXWIDE_RESOURCE		(1L << 0x06)
#define X1f4_LXWIDE_TEXTFLAT		(1L << 0x07)

/*
 * mxdeck flag definitions
 */
#define X1f4_MXDECK_TRANS_MASK		(1u << 0x00)

/*
 * mxdeck error definitions
 */
#define X1f4_MXDECK_FREE_ERROR		X1f4_I0CLIP_FREE_ERROR
#define X1f4_MXDECK_LINK_ERROR		X1f4_I0CLIP_LINK_ERROR
#define X1f4_MXDECK_MODE_ERROR		X1f4_I0CLIP_MODE_ERROR

/*
 * mxdeck error definitions (continued)
 */
#define X1f4_MXDECK_EVER_MATCH		X1f4_I0CLIP_EVER_MATCH

/*
 * textport flag definitions
 */
#define X1f4_TEXTPORT_AUTOLINK		(1L << 0x00)
#define X1f4_TEXTPORT_CASTTYPE		(1L << 0x01)
#define X1f4_TEXTPORT_CODELINK		(1L << 0x02)
#define X1f4_TEXTPORT_MISSBAIL		(1L << 0x03)
#define X1f4_TEXTPORT_NODELIST		(1L << 0x04)
#define X1f4_TEXTPORT_RESOURCE		(1L << 0x05)
#define X1f4_TEXTPORT_RUN1LIST		(1L << 0x06)
#define X1f4_TEXTPORT_RUN2LIST		(1L << 0x07)
#define X1f4_TEXTPORT_SUB2LIST		(1L << 0x08)
#define X1f4_TEXTPORT_SUBFLIST		(1L << 0x09)
#define X1f4_TEXTPORT_TEXTFLAT		(1L << 0x0a)
#define X1f4_TEXTPORT_TYPELIST		(1L << 0x0b)

/*
 * variables collections construction error definitions
 */
#define X1f4_CV_ALLOC_ERROR		1
#define X1f4_CV_NAMES_CLASH		2

/*
 * header convenience error definitions, not part of the library interface
 */
#define X1f4_I0CLIP_FREE_ERROR		-3
#define X1f4_I0CLIP_LINK_ERROR		-4
#define X1f4_I0CLIP_MODE_ERROR		-5

/*
 * header convenience error definitions, not part of the library interface
 */
#define X1f4_I0CLIP_EVER_MATCH		1

typedef struct x1f4_datapipe_type {
    const char *name;
    int (*copy) (void *, const char *, unsigned), type;
    unsigned size;
    void *text;
} x1f4_datapipe_type;

#if !defined __x1f4_datatype_type_defined__
typedef struct x1f4_datatype_type {
    const char *name;
    int (*flat) (void *, void **), (*lead) (void *, void **),
	(*line) (void *, void **), (*link) (void *, void **),
	(*shut) (void *, void **), (*slip) (void *, void **),
	type;
    unsigned size;
    void *context;
} x1f4_datatype_type;
#endif				/* !__x1f4_datatype_type_defined__ */

#if !defined __x1f4_datatype_type_defined__
# define __x1f4_datatype_type_defined__
#endif				/* !__x1f4_datatype_type_defined__ */

typedef struct x1f4_e2list_type {
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } misslink_set;
    struct {
	int *class;
    } flatline_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } resource_set;
} x1f4_e2list_type;

typedef struct x1f4_e2line_type {
    struct x1f4_e2list_type e2list;
    unsigned bits;
} x1f4_e2line_type;

typedef struct x1f4_e4fine_type {
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } resource_set;
} x1f4_e4fine_type;

typedef struct x1f4_e4line_type {
    int (*deck) (void **), (*fini) (void **, void *),
	(*free) (void *, void *), (*init) (void **, void *),
	(*link) (void *, void **, unsigned),
	(*mode) (void *, void **, unsigned),
	(*pick) (void *, void ***, int (*) (void *), unsigned, void **),
	(*slip) (void *, void *, void *, int (*) (void *)),
	(*swap) (void *, void *);
    void *data;
} x1f4_e4line_type;

typedef struct x1f4_e4less_type {
    struct x1f4_e4line_type misslink_set;
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } textflat_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } resource_set;
} x1f4_e4less_type;

typedef struct x1f4_eelookup_type {
    struct {
	int (*fix) (const void *, int, const char **, unsigned *);
	const void *context;
    } type_l;
    struct {
	const void *e4fine;
    } type_q;
} x1f4_eelookup_type;

typedef struct x1f4_fxrecord_type {
    int type;
    const char *name;
    unsigned length;
} x1f4_fxrecord_type;

typedef struct x1f4_eerecord_type {
    union {
	struct {
	    const char *name;
	    int f1st, f2nd;
	    unsigned size;
	} binary_r;
	struct {
	    const char *byte;
	} bytemiss;
	struct {
	    const char *name;
	    unsigned size;
	} c_lvalue;
	struct {
	    unsigned rank;
	    const void *last;
	} c_svalue;
	struct {
	    unsigned rank;
	    const void *last;
	} i_svalue;
	struct {
	    const char *name;
	    unsigned size;
	} v_lookup;
	struct {
	    const char *name;
	    unsigned size;
	} v_syntax;
	struct {
	    const char *name;
	    unsigned size;
	} f_lookup;
	struct {
	    const char *name;
	    unsigned size;
	} f_syntax;
	struct {
	    const char *name;
	    unsigned size;
	} misscall;
	struct {
	    int f1st, f2nd;
	} missturn;
	struct {
	    int f1st, f2nd;
	    struct x1f4_fxrecord_type fxrecord;
	    unsigned rank;
	} misstype;
	struct {
	    int join;
	} nearjoin;
	struct {
	    struct x1f4_fxrecord_type fxrecord;
	} surelose;
	struct {
	    struct x1f4_fxrecord_type fxrecord;
	} surestep;
	struct {
	    int f1st, f2nd;
	    unsigned rank;
	    const void *last;
	} t_svalue;
	struct {
	    const char *name;
	    unsigned size;
	} usedvoid;
    } data;
    unsigned code;
} x1f4_eerecord_type;

typedef struct x1f4_ejrecord_type {
    union {
	struct {
	    const char *name;
	    unsigned size;
	} misstype;
    } data;
    unsigned code;
} x1f4_ejrecord_type;

typedef struct x1f4_c1record_type {
    const char *line;
    struct {
	int (*rule) (void *, unsigned, unsigned);
	void *data;
    } hint;
    union {
	struct {
	    x1f4_eerecord_type eerecord;
	} e_syntax;
	struct {
	    x1f4_ejrecord_type ejrecord;
	} higherof;
	struct {
	    int slip, type;
	} m_return;
	struct {
	    unsigned size;
	} reserved;
	struct {
	    int type;
	} sidedata;
	struct {
	    unsigned size;
	} variable;
	struct {
	    int type;
	} w_scalar;
    } data;
    unsigned code, pick;
} x1f4_c1record_type;

typedef struct x1f4_a1record_type {
    const char *line;
    struct {
	int (*rule) (void *, unsigned, unsigned);
	void *data;
    } hint;
    union {
	struct {
	    x1f4_c1record_type c1record;
	} c_syntax;
	struct {
	    unsigned size;
	} flattype;
	struct {
	    x1f4_ejrecord_type ejrecord;
	} higherof;
	struct {
	    unsigned size;
	} lesslink;
	struct {
	    int type;
	} maintype;
	struct {
	    int type;
	} misslead;
	struct {
	    const char *fast;
	    union {
		struct {
		    unsigned name;
		} namecall;
		struct {
		    int slip, type;
		    unsigned name;
		} nametype;
		struct {
		    int slip, type;
		} sliptype;
	    } data;
	    unsigned code, size;
	} missline;
	struct {
	    unsigned size;
	} misslink;
	struct {
	    unsigned size;
	} missname;
	struct {
	    unsigned size;
	} misstype;
	struct {
	    const char *fast;
	    unsigned size;
	} postfeat;
	struct {
	    unsigned size;
	} reserved;
	struct {
	    int type;
	} sideline;
	struct {
	    unsigned size;
	} xdefined;
    } data;
    unsigned code, pick;
} x1f4_a1record_type;

#if !defined __x1f4_function_type_defined__
typedef struct x1f4_function_type {
    const char *name;
    int (*function) (void *, void *, void **), type;
    const int *args;
    unsigned count, flags, length;
} x1f4_function_type;
#endif				/* !__x1f4_function_type_defined__ */

#if !defined __x1f4_function_type_defined__
# define __x1f4_function_type_defined__
#endif				/* !__x1f4_function_type_defined__ */

typedef struct x1f4_a1screen_type {
    int (*back) (void *, const struct x1f4_function_type *),
	(*fast) (void *, const struct x1f4_function_type *),
	(*lose) (void *, const struct x1f4_function_type *);
    void *data;
} x1f4_a1screen_type;

typedef struct x1f4_cxflat_type {
    const char *name;
    int type;
    unsigned size;
} x1f4_cxflat_type;

#if !defined __x1f4_linetext_type_defined__
typedef struct x1f4_linetext_type {
    struct x1f4_function_type function;
    const void *context;
} x1f4_linetext_type;
#endif				/* !__x1f4_linetext_type_defined__ */

#if !defined __x1f4_linetext_type_defined__
# define __x1f4_linetext_type_defined__
#endif				/* !__x1f4_linetext_type_defined__ */

typedef struct x1f4_dxcast_type {
    int call, type;
    union {
	X1f4_E4_C_BILL bill;
	X1f4_E4_C_MODE mode;
	X1f4_E4_C_REAL real;
	X1f4_E4_C_TEXT text;
	X1f4_E4_C_USER user;
    } data;
} x1f4_dxcast_type;

typedef struct x1f4_dxflat_type {
    unsigned call;
    void *data;
} x1f4_dxflat_type;

#if !defined __x1f4_frame_type_defined__
typedef struct x1f4_frame_type {
    int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	(*mode) (void *, void **, unsigned),
	(*pick) (void *, void ***, int (*) (void *), unsigned, void **),
	(*slip) (void *, void *, void *, int (*) (void *));
    void *context;
} x1f4_frame_type;
#endif				/* !__x1f4_frame_type_defined__ */

#if !defined __x1f4_frame_type_defined__
# define __x1f4_frame_type_defined__
#endif				/* !__x1f4_frame_type_defined__ */

struct x1f4_nodetype_type;

#if !defined __x1f4_nodelink_type_defined__
typedef struct x1f4_nodelink_type {
    struct x1f4_nodetype_type *nodetype_data;
    void *slip;
} x1f4_nodelink_type;
#endif				/* !__x1f4_nodelink_type_defined__ */

#if !defined __x1f4_nodelink_type_defined__
# define __x1f4_nodelink_type_defined__
#endif				/* !__x1f4_nodelink_type_defined__ */

typedef struct x1f4_lxbail_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } textflat_set;
    struct {
	unsigned down, tear;
    } recovery_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } resource_set;
} x1f4_lxbail_type;

typedef struct x1f4_lxcast_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } textflat_set;
    struct {
	struct x1f4_eelookup_type *eelookup_data;
    } eelookup_set;
    struct {
	int type;
    } casttype_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } resource_set;
    struct {
	void *fine;
    } transfer_set;
    struct {
	unsigned miss;
	const struct x1f4_nodetype_type *nodetype_data;
    } datatype_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned),
	    (*pick) (void *, void ***, int (*) (void *), unsigned, void **),
	    (*slip) (void *, void *, void *, int (*) (void *));
	void *data;
    } autolink_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } codelink_set;
} x1f4_lxcast_type;

typedef struct x1f4_lxdata_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } textflat_set;
    struct {
	int type;
    } datatype_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } resource_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } codelink_set;
} x1f4_lxdata_type;

typedef struct x1f4_lxdate_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } textflat_set;
    struct {
	int type;
    } datetype_set;
    struct {
	int type;
    } timetype_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } resource_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } codelink_set;
} x1f4_lxdate_type;

typedef struct x1f4_lxfile_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } textflat_set;
    struct {
	int type;
    } datalink_set;
    struct {
	int type;
    } listlink_set;
    struct {
	int type;
    } filetype_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } resource_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } codelink_set;
} x1f4_lxfile_type;

typedef struct x1f4_lxflat_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } textflat_set;
    struct {
	int (*call) (void *, void *);
	void *text;
    } abstract_set;
    struct {
	struct x1f4_cxflat_type *cxflat_data;
	unsigned miss;
    } datatype_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } resource_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } codelink_set;
} x1f4_lxflat_type;

typedef struct x1f4_lxport_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } textflat_set;
    struct {
	int data, file, list, time;
    } sidelink_set;
    struct {
	int sshell, xshell;
    } porttype_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } resource_set;
    struct {
	int (*call) (void *, struct x1f4_nodelink_type *),
	    (*fine) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *),
	    (*miss) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *);
	void *text;
    } missbail_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } codelink_set;
    struct {
	int method;
    } thirdset_set;
    struct {
	int (*call) (void *);
	void *back;
    } shutline_set;
} x1f4_lxport_type;

#if !defined __x1f4_caselink_type_defined__
typedef struct x1f4_caselink_type {
    struct x1f4_caselink_type *caselink_data;
    struct x1f4_nodetype_type *nodetype_data;
    void *data;
    const void *text;
} x1f4_caselink_type;
#endif				/* !__x1f4_caselink_type_defined__ */

#if !defined __x1f4_caselink_type_defined__
# define __x1f4_caselink_type_defined__
#endif				/* !__x1f4_caselink_type_defined__ */

#if !defined __x1f4_trans_type_defined__
typedef struct x1f4_trans_type {
    int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	(*mode) (void *, void **, unsigned);
    void *context;
} x1f4_trans_type;
#endif				/* !__x1f4_trans_type_defined__ */

#if !defined __x1f4_trans_type_defined__
# define __x1f4_trans_type_defined__
#endif				/* !__x1f4_trans_type_defined__ */

#if !defined __x1f4_nodetype_type_defined__
typedef struct x1f4_nodetype_type {
    const char *name;
    int (*call) (struct x1f4_nodelink_type *), code,
	(*copy) (void *, void *, void **, const void *,
		 const struct x1f4_nodelink_type *),
	(*dump) (void *, struct x1f4_nodelink_type *),
	(*free) (void *, void *, struct x1f4_nodelink_type **,
		 const struct x1f4_nodelink_type *),
	(*hash) (void *, struct x1f4_nodelink_type **,
		 struct x1f4_nodelink_type *),
	(*lead) (void *, void **),
	(*miss) (struct x1f4_nodelink_type **, struct x1f4_nodelink_type **,
		 struct x1f4_nodelink_type *),
	(*move) (void *, void *, const struct x1f4_nodelink_type *,
		 const struct x1f4_nodelink_type *),
	(*node) (void *, void **, void *, const struct x1f4_nodelink_type *),
	(*pick) (void *, void *, struct x1f4_nodelink_type **,
		 const struct x1f4_nodelink_type *),
	(*post) (void *, void **, const struct x1f4_nodelink_type *),
	(*pull) (void *, void *, void *, const void *,
		 struct x1f4_trans_type *, struct x1f4_caselink_type **),
	(*push) (void *, void **, void *, const struct x1f4_nodelink_type *),
	(*slip) (void *, void **);
    unsigned flags, size;
    void *context;
} x1f4_nodetype_type;
#endif				/* !__x1f4_nodetype_type_defined__ */

#if !defined __x1f4_nodetype_type_defined__
# define __x1f4_nodetype_type_defined__
#endif				/* !__x1f4_nodetype_type_defined__ */

typedef struct x1f4_lxdecq_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } textflat_set;
    struct {
	struct x1f4_eelookup_type *eelookup_data;
    } eelookup_set;
    struct {
	int type;
    } decqtype_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } resource_set;
    struct {
	int (*call) (void *, struct x1f4_nodelink_type *),
	    (*fine) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *),
	    (*miss) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *);
	void *text;
    } missbail_set;
    struct {
	unsigned miss;
	const struct x1f4_nodetype_type *nodetype_data;
    } datatype_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } codelink_set;
} x1f4_lxdecq_type;

typedef struct x1f4_lxline_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } textflat_set;
    struct {
	struct x1f4_eelookup_type *eelookup_data;
    } eelookup_set;
    struct {
	int type;
    } casttype_set;
    struct {
	int type;
    } linetype_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } resource_set;
    struct {
	int (*call) (void *, struct x1f4_nodelink_type *),
	    (*fine) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *),
	    (*miss) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *);
	void *text;
    } missbail_set;
    struct {
	void *fine;
    } transfer_set;
    struct {
	unsigned miss;
	const struct x1f4_nodetype_type *nodetype_data;
    } datatype_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned),
	    (*pick) (void *, void ***, int (*) (void *), unsigned, void **),
	    (*slip) (void *, void *, void *, int (*) (void *));
	void *data;
    } autolink_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } codelink_set;
} x1f4_lxline_type;

typedef struct x1f4_lxlist_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } textflat_set;
    struct {
	struct x1f4_eelookup_type *eelookup_data;
    } eelookup_set;
    struct {
	int type;
    } casttype_set;
    struct {
	int type;
    } listtype_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } resource_set;
    struct {
	int (*call) (void *, struct x1f4_nodelink_type *),
	    (*fine) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *),
	    (*miss) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *);
	void *text;
    } missbail_set;
    struct {
	void *fine;
    } transfer_set;
    struct {
	unsigned miss;
	const struct x1f4_nodetype_type *nodetype_data;
    } datatype_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned),
	    (*pick) (void *, void ***, int (*) (void *), unsigned, void **),
	    (*slip) (void *, void *, void *, int (*) (void *));
	void *data;
    } autolink_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } codelink_set;
} x1f4_lxlist_type;

typedef struct x1f4_lxmath_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } textflat_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } codelink_set;
} x1f4_lxmath_type;

typedef struct x1f4_textpipe_type {
    const char *name;
    int (*copy) (void *, const char *, unsigned);
    unsigned size;
    void *text;
} x1f4_textpipe_type;

typedef struct x1f4_lxnear_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } textflat_set;
    struct {
	int type;
    } casttype_set;
    struct {
	void *fine;
    } transfer_set;
    struct {
	unsigned miss;
	const struct x1f4_textpipe_type *textpipe_data;
    } nearpipe_set;
    struct {
	unsigned miss;
	const struct x1f4_datapipe_type *datapipe_data;
    } longpipe_set;
    struct {
	int (*link) (void *, void **, unsigned);
	void *data;
    } autolink_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } codelink_set;
} x1f4_lxnear_type;

typedef struct x1f4_lxtext_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } textflat_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } resource_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } autolink_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } codelink_set;
} x1f4_lxtext_type;

#if !defined __x1f4_operator_type_defined__
typedef struct x1f4_operator_type {
    const char *name;
    int (*operator) (void *, void **), priority, type;
    const int *args;
    unsigned flags, length;
    const void *extension1, *extension2;
} x1f4_operator_type;
#endif				/* !__x1f4_operator_type_defined__ */

#if !defined __x1f4_operator_type_defined__
# define __x1f4_operator_type_defined__
#endif				/* !__x1f4_operator_type_defined__ */

typedef struct x1f4_lxtrap_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } textflat_set;
    struct {
	struct x1f4_eelookup_type *eelookup_data;
    } eelookup_set;
    struct {
	int type;
    } casttype_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } resource_set;
    struct {
	void *fine;
    } transfer_set;
    struct {
	int (*get) (void *, int, int, const struct x1f4_operator_type **);
	void *context;
    } implicit_set;
    struct {
	int (*get) (void *, int, int, const struct x1f4_linetext_type **);
	void *context;
    } composer_set;
    struct {
	unsigned miss;
	const struct x1f4_nodetype_type *nodetype_data;
    } datatype_set;
    struct {
	int (*link) (void *, void **, unsigned);
	void *data;
    } autolink_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } codelink_set;
} x1f4_lxtrap_type;

typedef struct x1f4_lxwide_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } textflat_set;
    struct {
	struct x1f4_eelookup_type *eelookup_data;
    } eelookup_set;
    struct {
	int type;
    } casttype_set;
    struct {
	int type;
    } widetype_set;
    struct {
	int node;
    } textnode_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } resource_set;
    struct {
	int (*call) (void *, struct x1f4_nodelink_type *),
	    (*fine) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *),
	    (*miss) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *);
	void *text;
    } missbail_set;
    struct {
	void *fine;
    } transfer_set;
    struct {
	unsigned miss;
	const struct x1f4_nodetype_type *nodetype_data;
    } datatype_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned),
	    (*pick) (void *, void ***, int (*) (void *), unsigned, void **),
	    (*slip) (void *, void *, void *, int (*) (void *));
	void *data;
    } autolink_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } codelink_set;
} x1f4_lxwide_type;

typedef struct x1f4_lxnote_type {
    int (*bset) (void *, const struct x1f4_operator_type **),
	(*cfix) (void *, unsigned, void *),
	(*clip) (const void *, struct x1f4_nodetype_type **, int *),
	(*dset) (void *, const struct x1f4_datatype_type **),
	(*fini) (void **),
	(*fset) (void *, const struct x1f4_linetext_type **),
	(*jack) (void *, const struct x1f4_datatype_type *), (*near) (void *),
	(*seek) (const void *),
	(*tile) (void **, unsigned, struct x1f4_lxwide_type *, unsigned,
		 const void *), (*vset) (void *, void **);
} x1f4_lxnote_type;

typedef struct x1f4_lxtile_type {
    int (*note) (const struct x1f4_lxnote_type **);
    unsigned bits;
    const void *data;
} x1f4_lxtile_type;

typedef struct x1f4_lxslip_type {
    int (*note) (const struct x1f4_lxnote_type **);
    void *slip;
} x1f4_lxslip_type;

typedef struct x1f4_mxdeck_type {
    void *trans;
} x1f4_mxdeck_type;

typedef struct x1f4_indexset_type {
    struct {
	void *text;
    } function_set;
    struct {
	void *text;
    } variable_set;
    struct {
	struct x1f4_datatype_type *datatype_data;
    } datatype_set;
    struct {
	struct x1f4_nodetype_type *nodetype_data;
	unsigned miss;
    } nodetype_set;
    struct {
	void *fine;
    } transfer_set;
    struct {
	int type;
    } casttype_set;
    struct {
	int (*deck) (void **);
	struct x1f4_e2line_type e2line;
	void *less, *text;
    } autodeck_set;
    struct {
	struct x1f4_lxslip_type *lxslip_data;
	unsigned miss;
    } sliplong_set;
    struct {
	const struct x1f4_operator_type *const *operator1s, *const *operator2s;
    } operator_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned),
	    (*pick) (void *, void ***, int (*) (void *), unsigned, void **),
	    (*slip) (void *, void *, void *, int (*) (void *));
	void *data;
    } autolink_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } codelink_set;
    struct {
	struct x1f4_eelookup_type eelookup;
    } eelookup_set;
} x1f4_indexset_type;

typedef struct x1f4_textport_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } textflat_set;
    struct {
	int type;
    } casttype_set;
    struct {
	int type;
    } lasttype_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } resource_set;
    struct {
	int (*call) (void *, struct x1f4_nodelink_type *),
	    (*fine) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *),
	    (*miss) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *);
	void *text;
    } missbail_set;
    struct {
	int *class;
    } autodeck_set;
    struct {
	const void *miss;
    } datatype_set;
    struct {
	const struct x1f4_lxtile_type *lxtile_data;
	unsigned miss;
    } tilelong_set;
    struct {
	const struct x1f4_nodetype_type *nodetype_data;
	unsigned miss;
    } nodetype_set;
    struct {
	const struct x1f4_operator_type *const *const *operator1s_set,
	    *const *const *operator2s_set;
    } operator_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned),
	    (*pick) (void *, void ***, int (*) (void *), unsigned, void **),
	    (*slip) (void *, void *, void *, int (*) (void *));
	void *data;
    } autolink_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } codelink_set;
} x1f4_textport_type;

typedef struct x1f4_ndbA_type {
} x1f4_ndbA_type;

typedef struct x1f4_ndbC_type {
} x1f4_ndbC_type;

typedef struct x1f4_ndba_type {
} x1f4_ndba_type;

typedef struct x1f4_ndbc_type {
} x1f4_ndbc_type;

typedef struct x1f4_odbA_type {
} x1f4_odbA_type;

typedef struct x1f4_odbC_type {
} x1f4_odbC_type;

typedef struct x1f4_odbS_type {
} x1f4_odbS_type;

typedef struct x1f4_odba_type {
} x1f4_odba_type;

typedef struct x1f4_odbc_type {
} x1f4_odbc_type;

typedef struct x1f4_odbs_type {
} x1f4_odbs_type;

typedef struct x1f4_rdbl_type {
    int type;
    unsigned flags;
    const void *data, *miss;
} x1f4_rdbl_type;

typedef struct x1f4_rdbo_type {
    int type;
    unsigned flags;
    const void *data, *miss;
} x1f4_rdbo_type;

typedef struct x1f4_sdbl_type {
    int type;
    unsigned flags;
    const void *data, *edbx;
} x1f4_sdbl_type;

typedef struct x1f4_sdbo_type {
    int type;
    unsigned flags;
    const void *data;
} x1f4_sdbo_type;

typedef struct x1f4_tdbl_type {
} x1f4_tdbl_type;

typedef struct x1f4_tdbo_type {
} x1f4_tdbo_type;

typedef struct x1f4_1stscope_type {
    const struct x1f4_ndbA_type *ndbA_data;
    const struct x1f4_ndbC_type *ndbC_data;
    const struct x1f4_ndba_type *ndba_data;
    const struct x1f4_ndbc_type *ndbc_data;
    const struct x1f4_odbA_type *odbA_data;
    const struct x1f4_odbC_type *odbC_data;
    const struct x1f4_odbS_type *odbS_data;
    const struct x1f4_odba_type *odba_data;
    const struct x1f4_odbc_type *odbc_data;
    const struct x1f4_odbs_type *odbs_data;
    const struct x1f4_rdbl_type *rdbl_data;
    const struct x1f4_rdbo_type *rdbo_data;
    const struct x1f4_sdbl_type *sdbl_data;
    const struct x1f4_sdbo_type *sdbo_data;
    const struct x1f4_tdbl_type *tdbl_data;
    const struct x1f4_tdbo_type *tdbo_data;
    unsigned bits1;
} x1f4_1stscope_type;

typedef struct x1f4_2ndscope_type {
    unsigned bits;
    const void *line, *rank;
} x1f4_2ndscope_type;

typedef struct x1f4_a1_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } textflat_set;
    struct {
	struct x1f4_eelookup_type *eelookup_data;
    } eelookup_set;
    struct {
	int (*fix) (const void *, const struct x1f4_function_type *, void **),
	    (*get) (const char *, unsigned, const void *,
		    const struct x1f4_function_type **);
	const void *context;
    } function_set;
    struct {
	const void *context;
    } variable_set;
    struct {
	int type;
    } casttype_set;
    struct {
	int (*get) (void *, int, int, const struct x1f4_operator_type **);
	void *context;
    } implicit_set;
    struct {
	int (*get) (void *, int, int, const struct x1f4_linetext_type **);
	void *context;
    } composer_set;
    struct {
	struct x1f4_a1record_type *a1record_data;
    } bcollect_set;
    struct {
	void *fine;
    } transfer_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *context;
    } resource_set;
    struct {
	int (*link) (void *, void **, unsigned),
	    (*pick) (void *, void ***, int (*) (void *), unsigned, void **);
	void *context;
    } autolead_set;
    struct {
	const void *miss;
    } datatype_set;
    struct {
	const void *miss;
    } sidetype_set;
    struct {
	int (*link) (void *, void **, unsigned);
	void *data;
    } autolink_set;
    const struct x1f4_operator_type *const *operator1s, *const *operator2s;
} x1f4_a1_type;

typedef struct x1f4_c1_type {
    int completion, detail;
    struct {
	int (*fix) (const void *, const struct x1f4_function_type *, void **),
	    (*get) (const char *, unsigned, const void *,
		    const struct x1f4_function_type **);
	const void *context;
    } function_set;
    struct {
	const void *context;
    } variable_set;
    struct {
	int type;
	void *text;
    } castlink_set;
    struct {
	int (*get) (void *, int, int, const struct x1f4_operator_type **);
	void *context;
    } implicit_set;
    struct {
	int (*get) (void *, int, int, const struct x1f4_linetext_type **);
	void *context;
    } composer_set;
    struct {
	struct x1f4_c1record_type *c1record_data;
    } bcollect_set;
    struct {
	void *fine;
    } transfer_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *context;
    } resource_set;
    struct {
	int (*link) (void *, void **, unsigned),
	    (*pick) (void *, void ***, int (*) (void *), unsigned, void **);
	void *context;
    } autolead_set;
    struct {
	const void *miss;
    } datatype_set;
    struct {
	const void *miss;
    } sidetype_set;
    const struct x1f4_operator_type *const *operator1s, *const *operator2s;
} x1f4_c1_type;

typedef struct x1f4_transfer_type {
    const struct x1f4_function_type *function_data;
    void *context, **input, *output;
} x1f4_transfer_type;

typedef struct x1f4_dispatch_type {
    int (*call) (void *, int, void *, struct x1f4_dispatch_type **);
    struct x1f4_transfer_type transfer;
    void *back;
} x1f4_dispatch_type;

typedef struct x1f4_variable_type {
    const char *name;
    int type;
    unsigned flags, length;
} x1f4_variable_type;

typedef struct x1f4_stateset_type {
    int (*get) (const void *, const struct x1f4_variable_type *, void **);
    const void *context;
} x1f4_stateset_type;

typedef struct x1f4_attributes_type {
    int completion, terminator;
    struct {
	int (*fix) (const void *, const struct x1f4_function_type *, void **),
	    (*get) (const char *, unsigned, const void *,
		    const struct x1f4_function_type **);
	const void *context;
    } function_set;
    struct {
	int (*get) (const char *, unsigned, const void *,
		    const struct x1f4_variable_type **, void **);
	const void *context;
    } variable_set;
    struct {
	int (*get) (void *, int, int, const struct x1f4_operator_type **);
	void *context;
    } implicit_set;
    struct {
	int (*get) (void *, int, int, const struct x1f4_linetext_type **);
	void *context;
    } composer_set;
    struct {
	struct x1f4_eerecord_type *eerecord_data;
    } bcollect_set;
    struct {
	void *fine;
    } transfer_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *context;
    } resource_set;
    struct {
	unsigned *s1st, *s2nd;
    } internal_set;
    struct {
	void *v1st, *v2nd;
    } datalink_set;
    struct {
	int type;
    } sequence_set;
    const struct x1f4_operator_type *const *operator1s, *const *operator2s;
} x1f4_attributes_type;

extern const char *const x1f4_c1_empty_string;

extern const void *const x1f4_a1_walk_link;

extern const struct x1f4_function_type *const x1f4_e4_computables,
    x1f4_e4_defaults[];

extern int x1f4_aime_program
    (void *, void *);
extern int x1f4_bset_lxcast
    (void *, const struct x1f4_operator_type **);
extern int x1f4_bset_lxmath
    (void *, const struct x1f4_operator_type **);
extern int x1f4_bset_lxtext
    (void *, const struct x1f4_operator_type **);
extern int x1f4_call_lxbail
    (void *, struct x1f4_nodelink_type *);
extern int x1f4_call_lxlead
    (struct x1f4_nodelink_type *);
extern int x1f4_case_expression
    (void *, int *);
extern int x1f4_cfix_lxdecq
    (void *, unsigned, void *);
extern int x1f4_cfix_lxline
    (void *, unsigned, void *);
extern int x1f4_cfix_lxlist
    (void *, unsigned, void *);
extern int x1f4_check_identifier
    (const char *);
extern int x1f4_clip_expression
    (void *, void *, unsigned);
extern int x1f4_clip_lxdata
    (struct x1f4_nodetype_type **, int *);
extern int x1f4_clip_lxdate
    (struct x1f4_nodetype_type **, int *);
extern int x1f4_clip_lxdecq
    (struct x1f4_nodetype_type **, int *);
extern int x1f4_clip_lxfile
    (struct x1f4_nodetype_type **, int *);
extern int x1f4_clip_lxline
    (struct x1f4_nodetype_type **, int *);
extern int x1f4_clip_lxlist
    (struct x1f4_nodetype_type **, int *);
extern int x1f4_clip_lxport
    (struct x1f4_nodetype_type **, int *);
extern int x1f4_copy_e4ll
    (void *, struct x1f4_frame_type *);
extern int x1f4_copy_expression
    (void **, void *);
extern int x1f4_copy_lxdata
    (void *, void *, void **, const void *,
     const struct x1f4_nodelink_type *);
extern int x1f4_copy_lxdate
    (void *, void *, void **, const void *,
     const struct x1f4_nodelink_type *);
extern int x1f4_copy_lxdecq
    (void *, void *, void **, const void *,
     const struct x1f4_nodelink_type *);
extern int x1f4_copy_lxfile
    (void *, void *, void **, const void *,
     const struct x1f4_nodelink_type *);
extern int x1f4_copy_lxlist
    (void *, void *, void **, const void *,
     const struct x1f4_nodelink_type *);
extern int x1f4_copy_lxtime
    (void *, void *, void **, const void *,
     const struct x1f4_nodelink_type *);
extern int x1f4_copy_mxdeck
    (void **, void *);
extern int x1f4_count_cdigits
    (unsigned, unsigned);
extern int x1f4_count_lcdigits
    (unsigned long, unsigned);
extern int x1f4_data_lxfile
    (void *, void *);
extern int x1f4_data_lxport
    (void *, void *);
extern int x1f4_date_lxport
    (void *, void *);
extern int x1f4_deck_e2list
    (void **);
extern int x1f4_deck_e4ll
    (void *, void **, int (**) (void **));
extern int x1f4_dfix_lxnear
    (void *, unsigned, void *);
extern int x1f4_dset_lxdata
    (void *, const struct x1f4_datatype_type **);
extern int x1f4_dset_lxdate
    (void *, const struct x1f4_datatype_type **);
extern int x1f4_dset_lxdecq
    (void *, const struct x1f4_datatype_type **);
extern int x1f4_dset_lxfile
    (void *, const struct x1f4_datatype_type **);
extern int x1f4_dset_lxflat
    (void *, const struct x1f4_datatype_type **);
extern int x1f4_dset_lxline
    (void *, const struct x1f4_datatype_type **);
extern int x1f4_dset_lxlist
    (void *, const struct x1f4_datatype_type **);
extern int x1f4_dset_lxport
    (void *, const struct x1f4_datatype_type **);
extern int x1f4_dump_lxdecq
    (void *, struct x1f4_nodelink_type *);
extern int x1f4_dump_lxlist
    (void *, struct x1f4_nodelink_type *);
extern int x1f4_dump_type
    (void *, int (*) (void *, const char *, unsigned), int,
     const struct x1f4_eelookup_type *);
extern int x1f4_ever_program
    (void *, void *);
extern int x1f4_ever_shuffle
    (void *, void *);
extern int x1f4_fast_e4ll
    (void *, void **);
extern int x1f4_fast_indexset
    (struct x1f4_indexset_type *, unsigned, struct x1f4_textport_type *);
extern int x1f4_fast_program
    (void *, void *);
extern int x1f4_file_lxport
    (void *, void *);
extern int x1f4_fill_mxdeck
    (void *, void *);
extern int x1f4_find_lxfset
    (void *, void **, void ***);
extern int x1f4_find_mxpath
    (void *, const char *, unsigned, const void **);
extern int x1f4_fine_lxbail
    (void *, struct x1f4_nodelink_type **, struct x1f4_nodelink_type *);
extern int x1f4_fini_e2list
    (void **, void *);
extern int x1f4_fini_e4fine
    (void **);
extern int x1f4_fini_e4ll
    (void **);
extern int x1f4_fini_expression
    (void *);
extern int x1f4_fini_lxbail
    (void **);
extern int x1f4_fini_lxcast
    (void **);
extern int x1f4_fini_lxdata
    (void **);
extern int x1f4_fini_lxdate
    (void **);
extern int x1f4_fini_lxdecq
    (void **);
extern int x1f4_fini_lxfile
    (void **);
extern int x1f4_fini_lxflat
    (void **);
extern int x1f4_fini_lxfset
    (void **);
extern int x1f4_fini_lxline
    (void **);
extern int x1f4_fini_lxlist
    (void **);
extern int x1f4_fini_lxmath
    (void **);
extern int x1f4_fini_lxnear
    (void **);
extern int x1f4_fini_lxport
    (void **);
extern int x1f4_fini_lxtext
    (void **);
extern int x1f4_fini_lxtrap
    (void **);
extern int x1f4_fini_mxdeck
    (void **);
extern int x1f4_fini_program
    (void **);
extern int x1f4_fini_shuffle
    (void **);
extern int x1f4_flat_indexset
    (struct x1f4_indexset_type *);
extern int x1f4_flat_lxdata
    (void *, void **);
extern int x1f4_flat_lxdate
    (void *, void **);
extern int x1f4_flat_lxdecq
    (void *, void **);
extern int x1f4_flat_lxfile
    (void *, void **);
extern int x1f4_flat_lxlist
    (void *, void **);
extern int x1f4_flat_lxtime
    (void *, void **);
extern int x1f4_flat_program
    (void *);
extern int x1f4_free_e2list
    (void *, void *);
extern int x1f4_free_lxdata
    (void *, void *, struct x1f4_nodelink_type **,
     const struct x1f4_nodelink_type *);
extern int x1f4_free_lxdate
    (void *, void *, struct x1f4_nodelink_type **,
     const struct x1f4_nodelink_type *);
extern int x1f4_free_lxdecq
    (void *, void *, struct x1f4_nodelink_type **,
     const struct x1f4_nodelink_type *);
extern int x1f4_free_lxfile
    (void *, void *, struct x1f4_nodelink_type **,
     const struct x1f4_nodelink_type *);
extern int x1f4_free_lxlist
    (void *, void *, struct x1f4_nodelink_type **,
     const struct x1f4_nodelink_type *);
extern int x1f4_free_lxtime
    (void *, void *, struct x1f4_nodelink_type **,
     const struct x1f4_nodelink_type *);
extern int x1f4_fset_lxcast
    (void *, const struct x1f4_linetext_type **);
extern int x1f4_fset_lxdata
    (void *, const struct x1f4_linetext_type **);
extern int x1f4_fset_lxdate
    (void *, const struct x1f4_linetext_type **);
extern int x1f4_fset_lxdecq
    (void *, const struct x1f4_linetext_type **);
extern int x1f4_fset_lxfile
    (void *, const struct x1f4_linetext_type **);
extern int x1f4_fset_lxline
    (void *, const struct x1f4_linetext_type **);
extern int x1f4_fset_lxlist
    (void *, const struct x1f4_linetext_type **);
extern int x1f4_fset_lxmath
    (void *, const struct x1f4_linetext_type **);
extern int x1f4_fset_lxnear
    (void *, const struct x1f4_linetext_type **);
extern int x1f4_fset_lxport
    (void *, const struct x1f4_linetext_type **);
extern int x1f4_fset_lxtext
    (void *, const struct x1f4_linetext_type **);
extern int x1f4_fset_lxtrap
    (void *, const struct x1f4_linetext_type **);
extern int x1f4_hack_expression
    (void *, struct x1f4_variable_type *, void *);
extern int x1f4_hash_lxdecq
    (void *, struct x1f4_nodelink_type **, struct x1f4_nodelink_type *);
extern int x1f4_hash_lxlist
    (void *, struct x1f4_nodelink_type **, struct x1f4_nodelink_type *);
extern int x1f4_head_expression
    (void *, void **);
extern int x1f4_head_program
    (void *);
extern int x1f4_head_shuffle
    (void *);
extern int x1f4_iNIt_expression
    (void **, const char **, unsigned, const struct x1f4_attributes_type *);
extern int x1f4_iNit_expression
    (void **, const char *, unsigned, const struct x1f4_attributes_type *);
extern int x1f4_imap_lxfile
    (void *, void *, int);
extern int x1f4_inIt_expression
    (void **, const char **, unsigned, const struct x1f4_attributes_type *);
extern int x1f4_inIt_program
    (void **, const char **, unsigned, const struct x1f4_c1_type *);
extern int x1f4_inIt_shuffle
    (void **, const char **, unsigned, const struct x1f4_a1_type *);
extern int x1f4_init_e2list
    (void **, unsigned, struct x1f4_e2list_type *);
extern int x1f4_init_e4fine
    (void **, unsigned, struct x1f4_e4fine_type *);
extern int x1f4_init_e4ll
    (void **, unsigned, struct x1f4_e4less_type *);
extern int x1f4_init_expression
    (void **, const char *, unsigned, const struct x1f4_attributes_type *);
extern int x1f4_init_lxbail
    (void **, unsigned, const struct x1f4_lxbail_type *);
extern int x1f4_init_lxcast
    (void **, unsigned, const struct x1f4_lxcast_type *);
extern int x1f4_init_lxdata
    (void **, unsigned, const struct x1f4_lxdata_type *);
extern int x1f4_init_lxdate
    (void **, unsigned, const struct x1f4_lxdate_type *);
extern int x1f4_init_lxdecq
    (void **, unsigned, const struct x1f4_lxdecq_type *);
extern int x1f4_init_lxfile
    (void **, unsigned, const struct x1f4_lxfile_type *);
extern int x1f4_init_lxflat
    (void **, unsigned, const struct x1f4_lxflat_type *);
extern int x1f4_init_lxfset
    (void **);
extern int x1f4_init_lxline
    (void **, unsigned, const struct x1f4_lxline_type *);
extern int x1f4_init_lxlist
    (void **, unsigned, const struct x1f4_lxlist_type *);
extern int x1f4_init_lxmath
    (void **, unsigned, const struct x1f4_lxmath_type *);
extern int x1f4_init_lxnear
    (void **, unsigned, const struct x1f4_lxnear_type *);
extern int x1f4_init_lxport
    (void **, unsigned, const struct x1f4_lxport_type *);
extern int x1f4_init_lxtext
    (void **, unsigned, const struct x1f4_lxtext_type *);
extern int x1f4_init_lxtrap
    (void **, unsigned, const struct x1f4_lxtrap_type *);
extern int x1f4_init_mxdeck
    (void **, unsigned, struct x1f4_mxdeck_type *);
extern int x1f4_init_program
    (void **, const char *, unsigned, const struct x1f4_c1_type *);
extern int x1f4_init_shuffle
    (void **, const char *, unsigned, const struct x1f4_a1_type *);
extern int x1f4_lame_program
    (void *, int (*) (void *, const char *, unsigned), const char *, unsigned,
     struct x1f4_c1record_type *, struct x1f4_eelookup_type *);
extern int x1f4_lame_shuffle
    (void *, int (*) (void *, const char *, unsigned), const char *, unsigned,
     struct x1f4_a1record_type *, struct x1f4_eelookup_type *);
extern int x1f4_lead_expression
    (void *);
extern int x1f4_lead_lxdata
    (void *, void **);
extern int x1f4_lead_lxdate
    (void *, void **);
extern int x1f4_lead_lxdecq
    (void *, void **);
extern int x1f4_lead_lxfile
    (void *, void **);
extern int x1f4_lead_lxline
    (void *, void **);
extern int x1f4_lead_lxlist
    (void *, void **);
extern int x1f4_lead_lxtime
    (void *, void **);
extern int x1f4_lead_ssport
    (void *, void **);
extern int x1f4_lead_xsport
    (void *, void **);
extern int x1f4_lime_mxdeck
    (void *, void *, int (*) (void *, const void *));
extern int x1f4_line_e2list
    (void **, void *);
extern int x1f4_line_e4ll
    (void *, struct x1f4_trans_type *);
extern int x1f4_line_expression
    (void *);
extern int x1f4_line_lxdata
    (void *, void **);
extern int x1f4_line_lxdate
    (void *, void **);
extern int x1f4_line_lxfile
    (void *, void **);
extern int x1f4_line_lxlist
    (void *, void **);
extern int x1f4_line_lxtime
    (void *, void **);
extern int x1f4_link_e2list
    (void *, void **, unsigned);
extern int x1f4_link_e4lf
    (void *, void **, unsigned);
extern int x1f4_link_expression
    (void *, void *);
extern int x1f4_link_lxdata
    (void *, void **);
extern int x1f4_link_lxdate
    (void *, void **);
extern int x1f4_link_lxfile
    (void *, void **);
extern int x1f4_link_lxlist
    (void *, void **);
extern int x1f4_link_lxtime
    (void *, void **);
extern int x1f4_link_program
    (void *);
extern int x1f4_link_shuffle
    (void *);
extern int x1f4_list_lxfile
    (void *, void *);
extern int x1f4_list_lxport
    (void *, void *);
extern int x1f4_list_state
    (void *, void *, int (*) (void *, void *, struct x1f4_variable_type *));
extern int x1f4_lock_e4ll
    (void *);
extern int x1f4_lock_lxcast
    (void *, int, int, const struct x1f4_linetext_type **);
extern int x1f4_long_program
    (void *, int *, void *, int (*) (void *), void *);
extern int x1f4_long_shuffle
    (void *, int *, void *, int (*) (void *), void *);
extern int x1f4_look_indexset
    (const void *, int, const char **, unsigned *);
extern int x1f4_look_program
    (void *, unsigned *);
extern int x1f4_look_shuffle
    (void *, unsigned *);
extern int x1f4_miss_expression
    (void *, void *, void *);
extern int x1f4_mode_e2list
    (void *, void **, unsigned);
extern int x1f4_miss_lxbail
    (void *, struct x1f4_nodelink_type **, struct x1f4_nodelink_type *);
extern int x1f4_move_lxlist
    (void *, void *, const struct x1f4_nodelink_type *,
     const struct x1f4_nodelink_type *);
extern int x1f4_near_lxcast
    (void *);
extern int x1f4_near_lxlead
    (void *, struct x1f4_nodelink_type **, struct x1f4_nodelink_type **,
     struct x1f4_nodelink_type *);
extern int x1f4_near_lxmath
    (void *);
extern int x1f4_near_lxtext
    (void *);
extern int x1f4_near_shuffle
    (void **, void *);
extern int x1f4_ness_expression
    (void *, const struct x1f4_attributes_type *);
extern int x1f4_node_lxdata
    (void *, void **, void *, const struct x1f4_nodelink_type *);
extern int x1f4_node_lxdate
    (void *, void **, void *, const struct x1f4_nodelink_type *);
extern int x1f4_node_lxdecq
    (void *, void **, void *, const struct x1f4_nodelink_type *);
extern int x1f4_node_lxfile
    (void *, void **, void *, const struct x1f4_nodelink_type *);
extern int x1f4_node_lxlist
    (void *, void **, void *, const struct x1f4_nodelink_type *);
extern int x1f4_node_lxtime
    (void *, void **, void *, const struct x1f4_nodelink_type *);
extern int x1f4_note_lxcast
    (const struct x1f4_lxnote_type **);
extern int x1f4_note_lxdata
    (const struct x1f4_lxnote_type **);
extern int x1f4_note_lxdate
    (const struct x1f4_lxnote_type **);
extern int x1f4_note_lxdecq
    (const struct x1f4_lxnote_type **);
extern int x1f4_note_lxfile
    (const struct x1f4_lxnote_type **);
extern int x1f4_note_lxflat
    (const struct x1f4_lxnote_type **);
extern int x1f4_note_lxline
    (const struct x1f4_lxnote_type **);
extern int x1f4_note_lxlist
    (const struct x1f4_lxnote_type **);
extern int x1f4_note_lxmath
    (const struct x1f4_lxnote_type **);
extern int x1f4_note_lxnear
    (const struct x1f4_lxnote_type **);
extern int x1f4_note_lxport
    (const struct x1f4_lxnote_type **);
extern int x1f4_note_lxtext
    (const struct x1f4_lxnote_type **);
extern int x1f4_note_lxtrap
    (const struct x1f4_lxnote_type **);
extern int x1f4_note_program
    (void *, int *, void *, int (*) (void *));
extern int x1f4_note_shuffle
    (void *, int *, void *, int (*) (void *));
extern int x1f4_omap_lxfile
    (void *, void *, int);
extern int x1f4_pack_expression
    (void *, struct x1f4_variable_type *, void *);
extern int x1f4_pass_lxbail
    (void *);
extern int x1f4_peek_expression
    (void *, void *, int (*) (void *, const struct x1f4_function_type *));
extern int x1f4_peer_shuffle
    (const char *, unsigned);
extern int x1f4_pfix_lxtrap
    (void *, void *,
     int (*) (void *, int, int, const struct x1f4_operator_type **));
extern int x1f4_pick_e2list
    (void *, void *, int (*) (void *), unsigned, void **);
extern int x1f4_pick_e4fine
    (const void *, int, const struct x1f4_linetext_type **);
extern int x1f4_pick_e4lf
    (void *, void ***, int (*) (void *), unsigned, void **);
extern int x1f4_pick_program
    (void *, void **);
extern int x1f4_pick_shuffle
    (void *, void **);
extern int x1f4_pipe_e4ll
    (void *, void *);
extern int x1f4_pipe_lxfile
    (void *, const char *, unsigned);
extern int x1f4_pipe_shuffle
    (void *, struct x1f4_a1screen_type *);
extern int x1f4_post_expression
    (void *, void *);
extern int x1f4_post_lxdata
    (void *, void **, const struct x1f4_nodelink_type *);
extern int x1f4_post_lxdecq
    (void *, void **, const struct x1f4_nodelink_type *);
extern int x1f4_post_lxfset
    (void *, void **, void ***);
extern int x1f4_post_lxlist
    (void *, void **, const struct x1f4_nodelink_type *);
extern int x1f4_post_mxpath
    (void *, const char *, unsigned, const void *);
extern int x1f4_pset_lxcast
    (void *, const struct x1f4_datatype_type **);
extern int x1f4_push_bill
    (void **, const char *, unsigned, unsigned, void *);
extern int x1f4_push_e4ll
    (void *);
extern int x1f4_push_lxdata
    (void *, void **, void *, const struct x1f4_nodelink_type *);
extern int x1f4_push_lxdate
    (void *, void **, void *, const struct x1f4_nodelink_type *);
extern int x1f4_push_lxdecq
    (void *, void **, void *, const struct x1f4_nodelink_type *);
extern int x1f4_push_lxfile
    (void *, void **, void *, const struct x1f4_nodelink_type *);
extern int x1f4_push_lxlist
    (void *, void **, void *, const struct x1f4_nodelink_type *);
extern int x1f4_push_lxtime
    (void *, void **, void *, const struct x1f4_nodelink_type *);
extern int x1f4_push_mode
    (void **, const char *, unsigned, unsigned, void *);
extern int x1f4_push_program
    (void *, void *);
extern int x1f4_push_real
    (void **, const char *, unsigned, unsigned, void *);
extern int x1f4_push_text
    (void **, const char *, unsigned, unsigned, void *);
extern int x1f4_push_variable
    (void **, const char *, unsigned, int, unsigned, void *);
extern int x1f4_qfix_lxtrap
    (void *, void *,
     int (*) (void *, int, int, const struct x1f4_linetext_type **));
extern int x1f4_rail_shuffle
    (void *);
extern int x1f4_rate_expression
    (void *);
extern int x1f4_seek_lxdata
    (void);
extern int x1f4_seek_lxdate
    (void);
extern int x1f4_seek_lxdecq
    (void);
extern int x1f4_seek_lxfile
    (void);
extern int x1f4_seek_lxline
    (void);
extern int x1f4_seek_lxlist
    (void);
extern int x1f4_seek_lxport
    (void);
extern int x1f4_seek_shuffle
    (void *, unsigned *);
extern int x1f4_shut_lxfile
    (void *, void **);
extern int x1f4_side_shuffle
    (void **, void *, void *);
extern int x1f4_size_expression
    (void *, unsigned *, unsigned *);
extern int x1f4_size_program
    (void *, unsigned *);
extern int x1f4_slip_e2list
    (void *, void *, void *, int (*) (void *));
extern int x1f4_slip_expression
    (void *, void *, unsigned, int *, void *, struct x1f4_transfer_type *);
extern int x1f4_slip_lxdata
    (void *, void **);
extern int x1f4_slip_lxdate
    (void *, void **);
extern int x1f4_slip_lxdecq
    (void *, void **);
extern int x1f4_slip_lxfile
    (void *, void **);
extern int x1f4_slip_lxline
    (void *, void **);
extern int x1f4_slip_lxlist
    (void *, void **);
extern int x1f4_slip_lxtime
    (void *, void **);
extern int x1f4_slip_program
    (void *);
extern int x1f4_slip_shuffle
    (void *);
extern int x1f4_slip_ssport
    (void *, void **);
extern int x1f4_slip_xsport
    (void *, void **);
extern int x1f4_stat_expression
    (void *, int (*) (void *, const char *, unsigned),
     struct x1f4_eerecord_type *, struct x1f4_eelookup_type *);
extern int x1f4_stat_program
    (void *, int (*) (void *, const char *, unsigned), const char *,
     struct x1f4_c1record_type *, struct x1f4_eelookup_type *);
extern int x1f4_stat_shuffle
    (void *, int (*) (void *, const char *, unsigned), const char *,
     struct x1f4_a1record_type *, struct x1f4_eelookup_type *);
extern int x1f4_swap_e2list
    (void *, void *);
extern int x1f4_sweep_program
    (void *);
extern int x1f4_tail_expression
    (void *, void **);
extern int x1f4_tail_program
    (void *);
extern int x1f4_tail_shuffle
    (void *);
extern int x1f4_test_identifier
    (const char *);
extern int x1f4_text_program
    (void *, int (*) (void *, void *), void *);
extern int x1f4_tile_lxdata
    (void **, unsigned, struct x1f4_lxwide_type *, unsigned, const void *);
extern int x1f4_tile_lxdate
    (void **, unsigned, struct x1f4_lxwide_type *, unsigned, const void *);
extern int x1f4_tile_lxdecq
    (void **, unsigned, struct x1f4_lxwide_type *, unsigned, const void *);
extern int x1f4_tile_lxfile
    (void **, unsigned, struct x1f4_lxwide_type *, unsigned, const void *);
extern int x1f4_tile_lxline
    (void **, unsigned, struct x1f4_lxwide_type *, unsigned, const void *);
extern int x1f4_tile_lxlist
    (void **, unsigned, struct x1f4_lxwide_type *, unsigned, const void *);
extern int x1f4_tile_lxmath
    (void **, unsigned, struct x1f4_lxwide_type *, unsigned, const void *);
extern int x1f4_tile_lxnear
    (void **, unsigned, struct x1f4_lxwide_type *, unsigned, const void *);
extern int x1f4_tile_lxport
    (void **, unsigned, struct x1f4_lxwide_type *, unsigned, const void *);
extern int x1f4_tile_lxtext
    (void **, unsigned, struct x1f4_lxwide_type *, unsigned, const void *);
extern int x1f4_tile_lxtrap
    (void **, unsigned, struct x1f4_lxwide_type *, unsigned, const void *);
extern int x1f4_type_e2list
    (struct x1f4_e4line_type *);
extern int x1f4_type_e4fine
    (void *, int *, const struct x1f4_linetext_type *);
extern int x1f4_type_expression
    (void *);
extern int x1f4_type_lxdata
    (struct x1f4_nodetype_type *, int);
extern int x1f4_type_lxdate
    (struct x1f4_nodetype_type *, int);
extern int x1f4_type_lxdecq
    (struct x1f4_nodetype_type *, int);
extern int x1f4_type_lxfile
    (struct x1f4_nodetype_type *, int);
extern int x1f4_type_lxline
    (struct x1f4_nodetype_type *, int);
extern int x1f4_type_lxlist
    (struct x1f4_nodetype_type *, int);
extern int x1f4_type_lxtime
    (struct x1f4_nodetype_type *, int);
extern int x1f4_type_ssport
    (struct x1f4_nodetype_type *, int);
extern int x1f4_type_xsport
    (struct x1f4_nodetype_type *, int);
extern int x1f4_vprint_bprogram
    (void *, int (*) (void *, const char *, unsigned), void *, unsigned,
     unsigned);
extern int x1f4_vprint_expression
    (void *, int (*) (void *, const char *, unsigned), void *, unsigned);
extern int x1f4_vprint_program
    (void *, int (*) (void *, const char *, unsigned), void *, unsigned);
extern int x1f4_vprint_xtfunction
    (void *, int (*) (void *, const char *, unsigned), void *,
     int (*) (void *, const char *, unsigned),
     const struct x1f4_function_type *, const struct x1f4_eelookup_type *);
extern int x1f4_vset_lxfile
    (void *, void **);
extern int x1f4_vset_lxtrap
    (void *, void **);
extern int x1f4_wait_lxport
    (void *, pid_t);

extern void x1f4_aime_version
    (const char **);
extern void x1f4_air_state
    (void *);
extern void x1f4_count_functions
    (const struct x1f4_function_type *, unsigned *);
extern void x1f4_hook_expression
    (void *, unsigned *);
extern void x1f4_list_expression
    (void *, void *, void (*this) (void *, const struct x1f4_variable_type *));
extern void x1f4_llink_operator1s
    (const struct x1f4_operator_type *const **);
extern void x1f4_llink_operator2s
    (const struct x1f4_operator_type *const **);
extern void x1f4_nprint_expression
    (unsigned *, void *, unsigned);
extern void x1f4_print_boperators
    (FILE *, const struct x1f4_operator_type *const *, int);
extern void x1f4_print_expression
    (FILE *, void *, unsigned);
extern void x1f4_print_function
    (FILE *, const struct x1f4_function_type *);
extern void x1f4_print_functions
    (FILE *, const struct x1f4_function_type *);
extern void x1f4_print_hfunction
    (FILE *, const struct x1f4_function_type *, const char *);
extern void x1f4_print_hfunctions
    (FILE *, const struct x1f4_function_type *, const char *);
extern void x1f4_print_htfunction
    (FILE *, const struct x1f4_function_type *, const char *, const void *,
     int (*) (const void *, int, const char **, unsigned *));
extern void x1f4_print_htfunctions
    (FILE *, const struct x1f4_function_type *, const char *, const void *,
     int (*) (const void *, int, const char **, unsigned *));
extern void x1f4_print_hvariables
    (void *, const struct x1f4_variable_type *, const char *);
extern void x1f4_print_operators
    (FILE *, const struct x1f4_operator_type *const *, unsigned);
extern void x1f4_print_tboperators
    (FILE *, const struct x1f4_operator_type *const *, int, const void *,
     int (*) (const void *, int, const char **, unsigned *));
extern void x1f4_print_variables
    (FILE *, const struct x1f4_variable_type *);
extern void x1f4_type_mset
    (struct x1f4_trans_type *);

#endif				/* __x1f4_aime_H__ */
