/*
 * xshell.h
 * Copyright (C) 2006-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __LIBx1f4_XSHELL_H__
#define __LIBx1f4_XSHELL_H__

#include <sys/types.h>

#include <xshell-names.h>

#define X1f4_XSHELL_ARGV_MASK		(1u << 0x00)
#define X1f4_XSHELL_BACK_MASK		(1u << 0x01)
#define X1f4_XSHELL_C3RD_MASK		(1u << 0x02)
#define X1f4_XSHELL_CALL_MASK		(1u << 0x03)
#define X1f4_XSHELL_HEAD_MASK		(1u << 0x04)
#define X1f4_XSHELL_LEAD_MASK		(1u << 0x05)
#define X1f4_XSHELL_LIFT_MASK		(1u << 0x06)
#define X1f4_XSHELL_LOOK_MASK		(1u << 0x07)
#define X1f4_XSHELL_MASK_MASK		(1u << 0x08)
#define X1f4_XSHELL_PATH_MASK		(1u << 0x09)
#define X1f4_XSHELL_TAIL_MASK		(1u << 0x0a)
#define X1f4_XSHELL_TYPE_MASK		(1u << 0x0b)

#define X1f4_XSHELL_KILL_C3RD		0
#define X1f4_XSHELL_MISS_C3RD		1
#define X1f4_XSHELL_NULL_C3RD		2

typedef struct x1f4_xshell_type {
    struct {
	int lead, lift;
    } adapter;
    struct {
	int (*call) (void *);
	void *back;
    } cleanup;
    struct {
	const char *const *argv, *path;
    } command;
    struct {
	int (*head) (void *), (*tail) (void *),
	    (*type) (void *, const char *, unsigned);
	void *look;
    } printer;
    struct {
	unsigned c3rd, mask;
    } trailer;
} x1f4_xshell_type;

extern int x1f4_deck_xshell(void *);
extern int x1f4_fini_xshell(void **);
extern int x1f4_hook_xshell(void *, pid_t *);
extern int x1f4_init_xshell(void **);
extern int x1f4_mode_xshell(void *, struct x1f4_xshell_type *, unsigned);
extern int x1f4_pipe_xshell(void *, int *, int *);
extern int x1f4_wait_xshell(void *);

#endif				/* __LIBx1f4_XSHELL_H__ */
