/*
 * vkeyfree.c
 * Copyright (C) 2006-2007, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>

#include <vtkey-types.h>

void
x1f4_free_vtkeydata(struct keytree_type *keytree_data)
{
    struct keytree_type *free_keytree;

    free_keytree = keytree_data;

    while (keytree_data->string) {
	struct keytree_type *keytree_text;

	free(keytree_data->string);

	keytree_text = (struct keytree_type *) keytree_data->children;
	if (keytree_text) {
	    x1f4_free_vtkeydata(keytree_text);
	}

	keytree_data++;
    }

    free(free_keytree);
}
