/*
 * space.f.c
 * Copyright (C) 2002-2008, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>

static const char prefix[] = "                ";

int
x1f4_fprint_space(FILE *file, unsigned f)
{
    int status = 0;

    while (f) {
	int excess;
	unsigned e;

	e = f < 16 ? f : 16;
	excess = fwrite(prefix, 1, e, file);
	if (excess < e) {
	    status = -1;
	    break;
	} else {
	    f -= e;
	    status += e;
	}
    }

    return status;
}
