/*
 * lcardinal.f.c
 * Copyright (C) 2006-2007, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <stdio.h>

#if defined LIBx1f4i0
# include <inter.h>
#endif				/* LIBx1f4i0 */
#if !defined LIBx1f4i0
# include <lcardinal.p.h>
#endif				/* !LIBx1f4i0 */

#define BASE_SIZE		(SIZEOF_UNSIGNED_LONG << 3)

int
x1f4_fprint_lcardinal(FILE *file, int big, unsigned base, unsigned long c)
{
    char data[BASE_SIZE], *mode;

    mode = data + BASE_SIZE;
    x1f4_xprint_lcardinal(&mode, big, base, c);

    return fprintf(file, "%.*s", (int) (data + BASE_SIZE - mode), mode);
}
