/*
 * lcardinal.f-fb.c
 * Copyright (C) 2002-2007, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <stdio.h>

#if defined LIBx1f4i0
# include <inter.h>
#endif				/* LIBx1f4i0 */
#if !defined LIBx1f4i0
# include <lcardinal.p-fb.h>
# include <zero-prefix.f-sb.h>
#endif				/* !LIBx1f4i0 */

#define BASE_SIZE		(SIZEOF_UNSIGNED_LONG << 3)
#define THIS_SIZE		(BASE_SIZE << 1)

int
x1f4_fprint_fblcardinal(FILE *file, int big, unsigned f, unsigned b,
			unsigned base, unsigned long c)
{
    int status;

    do {
	char data[THIS_SIZE], *mode;
	int excess;

	if (BASE_SIZE < f) {
	    status = x1f4_fprint_sb0prefix(file, BASE_SIZE, b, f - BASE_SIZE);
	    if (status < 0) {
		break;
	    } else {
		f = BASE_SIZE;
	    }
	} else {
	    status = 0;
	}

	mode = data + THIS_SIZE;
	x1f4_xprint_fblcardinal(&mode, big, f, b, base, c);

	excess = fprintf(file, "%.*s", (int) (data + THIS_SIZE - mode), mode);
	if (excess < 0) {
	    status = excess;
	} else {
	    status += excess;
	}
    } while (0);

    return status;
}
