/*
 * lcardinal-wx.c
 * Copyright (C) 2006-2007, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if !defined LIBx1f4i0
# include <lcardinal-x.h>
#endif				/* !LIBx1f4i0 */
#if defined LIBx1f4i0
# include <ctype.0.h>
# include <inter.h>
#endif				/* LIBx1f4i0 */

#if !defined LIBx1f4i0
# define C_TYPE_X(c_type_x, c) \
    ((c_type_x)[(c) >> 5] & 1 << ((c) & 31))
#endif				/* !LIBx1f4i0 */

static const unsigned c_type_1[] = {
/*
 *                   . .     .
 *
 * .
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00002600, 0x00000001, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
};

int
x1f4_parse_wxlcardinal(unsigned long *cardinal, const char *s, const char **e,
		       unsigned base)
{
    const char *f, *t;
    int c, status;

    t = s;
    c = *(const unsigned char *) t;
    do {
	if (C_TYPE_X(c_type_1, c)) {
	} else {
	    break;
	}
	t++;
	c = *(const unsigned char *) t;
    } while (1);
    status = x1f4_parse_xlcardinal(cardinal, t, &f, base);
    if (status) {
	if (f == t) {
	    if (e) {
		*e = s;
	    }
	} else {
	    if (e) {
		*e = f;
	    }
	}
    } else {
	if (e) {
	    *e = f;
	}
    }

    return status;
}
