/*
 * command-e.c
 * Copyright (C) 2003-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <stdlib.h>
#include <string.h>

#undef isodigit
#define isodigit(c) \
    (0x2f < (c) && (c) < 0x38)

int
x1f4_esplit_command(const char *line, unsigned back, unsigned post,
		    unsigned *argc_return, char ***argv_return)
{
    char *head;
    int status = 0;
    unsigned length;

    length = strlen(line);
    if (!(head = (char *) malloc(length + 1))) {
	status = -1;
    } else {
	char **argV;

	post += back + 17;

	if (!(argV = (char **) malloc(sizeof(char *) * post))) {
	    status = -1;
	    free(head);
	} else {
	    char **argv, c, *write;
	    const char *chars;
	    int argc = 0;
	    unsigned i;

	    argv = argV + back;
	    *argv++ = head;
	    chars = line;
	    write = head;
	    for (i = length; i; i--) {
		if ((c = *chars) == '\\') {
		    i--;
		    if (!i) {
			status = 1;
			break;
		    }
		    chars++;
		    switch ((c = *chars)) {
		    case 'a':
			*write++ = '\a';
			break;
		    case 'b':
			*write++ = '\b';
			break;
		    case 'f':
			*write++ = '\f';
			break;
		    case 'n':
			*write++ = '\n';
			break;
		    case 'r':
			*write++ = '\r';
			break;
		    case 't':
			*write++ = '\t';
			break;
		    case 'v':
			*write++ = '\v';
			break;
		    default:
			if (isodigit(c)) {
			    char o;
			    unsigned j;

			    j = i - 1;
			    if (2 < j) {
				j = 2;
			    }
			    o = c - 0x30;
			    for (; j; j--) {
				chars++;
				c = *chars;
				if (isodigit(c)) {
				    o <<= 3;
				    o += c - 0x30;
				    i--;
				} else {
				    chars--;
				    break;
				}
			    }

			    *write++ = o;
			} else {
			    *write++ = c;
			}
		    }
		} else if (c == 0x20) {
		    if (write == head) {
		    } else {
			if (!*(write - 1)) {
			} else {
			    *write++ = '\0';
			    argc++;
			    if (!(argc & 15)) {
				char **save_argv;

				if (!(save_argv = (char **)
				      realloc(argV,
					      sizeof(char *)
					      * (argc + post)))) {
				    status = -1;
				    break;
				}

				argV = save_argv;
				argv = argV + back + argc;
			    }

			    *argv++ = write;
			}
		    }
		} else {
		    *write++ = c;
		}

		chars++;
	    }

	    if (status) {
		free(head);
		free(argV);
	    } else {
		if (write == head) {
		} else {
		    if (!*(write - 1)) {
			argv--;
		    } else {
			argc++;
			*write = '\0';
		    }
		}

		*argc_return = argc;
		*argv_return = argV;

		argv[post - back - 17] = NULL;
	    }
	}
    }

    return status;
}
