/*
 * cardinal-x.c
 * Copyright (C) 2006-2007, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if !defined LIBx1f4i0
# include <cardinal.h>
#endif				/* !LIBx1f4i0 */
#if defined LIBx1f4i0
# include <inter.h>
#endif				/* LIBx1f4i0 */

int
x1f4_parse_xcardinal(unsigned *cardinal, const char *s, const char **e,
		     unsigned base)
{
    int status;

    do {
	if (!base) {
	    int c;

	    c = *s;
	    if (c != 0x30) {
		base = 10;
	    } else {
		const char *t;

		t = s;
		t++;
		c = *t;
		if ((c & ~0x20) != 0x58) {
		    if (c < 0x30 || 0x37 < c) {
			*cardinal = 0;

			if (!c) {
			    status = 0;
			} else {
			    status = 1;
			}

			if (e) {
			    *e = t;
			}

			break;
		    } else {
			base = 8;
		    }
		} else {
		    base = 16;
		    t++;
		}

		status = x1f4_parse_cardinal(cardinal, t, e, base);
		if (status) {
		    if (e) {
			if (*e == t) {
			    *e = s;
			}
		    }
		}

		break;
	    }
	}

	status = x1f4_parse_cardinal(cardinal, s, e, base);
    } while (0);

    return status;
}
