/*
 * zero-prefix.v-sb.c
 * Copyright (C) 2002-2007, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

static const char prefix[] = "0000000000000000";

int
x1f4_vprint_sb0prefix(void *data, int (*this) (void *, const char *, unsigned),
		      unsigned s, unsigned b, unsigned f)
{
    int status = 0;

    if (!b) {
	while (f) {
	    unsigned e;

	    e = f < 16 ? f : 16;
	    status = this(data, prefix, e);
	    if (status) {
		break;
	    } else {
		f -= e;
	    }
	}
    } else {
	unsigned v;

	s = s % b;
	if (s) {
	    s = b - s;
	    if (f < s) {
		s = f;
	    }
	    f -= s;
	}
	v = f % b;
	if (!v) {
	    v = b;
	}
	while (f) {
	    unsigned u;

	    u = v;
	    if (f < u) {
		u = f;
	    }
	    v = b;
	    f -= u;
	    while (u) {
		unsigned e;

		e = u < 16 ? u : 16;
		status = this(data, prefix, e);
		if (status) {
		    break;
		} else {
		    u -= e;
		}
	    }
	    if (status < 0) {
		break;
	    } else {
		status = this(data, ",", 1);
		if (status) {
		    break;
		} else {
		}
	    }
	}
	if (!(status < 0)) {
	    while (s) {
		unsigned e;

		e = s < 16 ? s : 16;
		status = this(data, prefix, e);
		if (status) {
		    break;
		} else {
		    s -= e;
		}
	    }
	}
    }

    return status;
}
