/*
 * xalist.c
 * Copyright (C) 2006, 2007, 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <stddef.h>
#include <stdlib.h>
#include <string.h>

#if SIZEOF_VOID_P == SIZEOF_LONG
# define integral_q			unsigned long
#else
# define integral_q			unsigned
#endif				/* SIZEOF_VOID_P == SIZEOF_LONG */

typedef struct xanode_type {
    struct xanode_type *last_xanode, *next_xanode;
    unsigned size;
    void *data;
} xanode_type;

typedef struct xalist_type {
    struct xanode_type *xanode_data;
} xalist_type;

int
_libx1f4i0_deck_xalist(void **xalist)
{
    struct xalist_type *xalist_data;
    struct xanode_type *xanode_data;

    xalist_data = *xalist;
    xanode_data = xalist_data->xanode_data;
    while (xanode_data) {
	struct xanode_type *next_xanode;

	next_xanode = xanode_data;
	xanode_data = xanode_data->next_xanode;
	free(next_xanode->data);
    }

    xalist_data->xanode_data = NULL;

    return 0;
}


int
_libx1f4i0_fini_xalist(void **xalist, void *none)
{
    struct xalist_type *xalist_data;
    struct xanode_type *xanode_data;

    xalist_data = *xalist;
    xanode_data = xalist_data->xanode_data;
    while (xanode_data) {
	struct xanode_type *next_xanode;

	next_xanode = xanode_data;
	xanode_data = xanode_data->next_xanode;
	free(next_xanode->data);
    }

    free(xalist_data);

    return 0;
}


int
_libx1f4i0_free_xalist(void *xalist, void *data)
{
    struct xanode_type *xanode_data;
    unsigned deck;

    deck = sizeof(struct xanode_type);
    deck += (16 - (deck & 15)) & 15;
    xanode_data = (void *) ((char *) data - deck);
    {
	struct xanode_type *last_xanode, *next_xanode;

	last_xanode = xanode_data->last_xanode;
	next_xanode = xanode_data->next_xanode;
	if (next_xanode) {
	    next_xanode->last_xanode = last_xanode;
	}
	if (last_xanode) {
	    last_xanode->next_xanode = next_xanode;
	} else {
	    struct xalist_type *xalist_data;

	    xalist_data = xalist;

	    xalist_data->xanode_data = next_xanode;
	}
    }

    free(xanode_data->data);

    return 0;
}


int
_libx1f4i0_init_xalist(void **xalist, void *none)
{
    int status;
    struct xalist_type *xalist_data;

    xalist_data = (struct xalist_type *) malloc(sizeof(struct xalist_type));
    if (!xalist_data) {
	status = -1;
    } else {
	status = 0;

	xalist_data->xanode_data = NULL;

	*xalist = xalist_data;
    }

    return status;
}


int
_libx1f4i0_link_xalist(void *xalist, void **link, unsigned size)
{
    int status;
    unsigned deck, flow;
    void *data;

    deck = sizeof(struct xanode_type);
    deck += (16 - (deck & 15)) & 15;

    flow = size + deck + 15;

    data = malloc(flow);
    if (!data) {
	status = -1;
    } else {
	struct xalist_type *xalist_data;
	struct xanode_type *xanode_data, *list_xanode;

	status = 0;

	{
	    integral_q post;
	    unsigned skip;

	    post = (integral_q) data;
	    skip = post;
	    skip = (16 - (skip & 15)) & 15;
	    xanode_data = (void *) ((char *) data + skip);
	}

	xalist_data = xalist;

	list_xanode = xalist_data->xanode_data;
	xalist_data->xanode_data = xanode_data;

	xanode_data->last_xanode = NULL;
	xanode_data->next_xanode = list_xanode;
	if (list_xanode) {
	    list_xanode->last_xanode = xanode_data;
	}

	xanode_data->data = data;
	xanode_data->size = size;

	*link = (void *) ((char *) xanode_data + deck);
    }

    return status;
}


int
_libx1f4i0_mode_xalist(void *xalist, void **link, unsigned size)
{
    int status;
    void *mode;

    status = _libx1f4i0_link_xalist(xalist, &mode, size);
    if (!status) {
	void *post;

	post = *link;
	if (post) {
	    struct xanode_type *xanode_data, *last_xanode;
	    unsigned deck, flow;

	    deck = sizeof(struct xanode_type);
	    deck += (16 - (deck & 15)) & 15;

	    xanode_data = (void *) ((char *) mode - deck);
	    last_xanode = (void *) ((char *) post - deck);

	    deck = xanode_data->size;
	    flow = last_xanode->size;
	    if (deck < flow) {
		flow = deck;
	    }

	    memcpy(mode, post, flow);

	    _libx1f4i0_free_xalist(xalist, post);
	}

	*link = mode;
    }

    return status;
}


int
_libx1f4i0_swap_xalist(void *c1st, void *c2nd)
{
    struct xalist_type xalist_class, *xalist_dana, *xalist_intl;

    xalist_dana = c1st;
    xalist_intl = c2nd;

    xalist_class = *xalist_dana;
    *xalist_dana = *xalist_intl;
    *xalist_intl = xalist_class;

    return 0;
}
