/*
 * tp.h
 * Copyright (C) 2010-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_tp_H__
#define __LIBx1f4_tp_H__

#include <e4.h>
#include <nt.h>

/*
 * textport generation flag definitions
 */
#define X1f4_TEXTPORT_AUTOLINK		(1L << 0x00)
#define X1f4_TEXTPORT_CASTTYPE		(1L << 0x01)
#define X1f4_TEXTPORT_CODELINK		(1L << 0x02)
#define X1f4_TEXTPORT_MISSBAIL		(1L << 0x03)
#define X1f4_TEXTPORT_NODELIST		(1L << 0x04)
#define X1f4_TEXTPORT_RESOURCE		(1L << 0x05)
#define X1f4_TEXTPORT_RUN1LIST		(1L << 0x06)
#define X1f4_TEXTPORT_RUN2LIST		(1L << 0x07)
#define X1f4_TEXTPORT_SUB2LIST		(1L << 0x08)
#define X1f4_TEXTPORT_SUBFLIST		(1L << 0x09)
#define X1f4_TEXTPORT_TEXTFLAT		(1L << 0x0a)
#define X1f4_TEXTPORT_TYPELIST		(1L << 0x0b)

typedef struct x1f4_lxtile_type {
    int (*note) (const struct x1f4_lxnote_type **);
    unsigned bits;
    const void *data;
} x1f4_lxtile_type;

#if !defined __x1f4_trans_type_defined__
typedef struct x1f4_trans_type {
    int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	(*mode) (void *, void **, unsigned);
    void *context;
} x1f4_trans_type;
#endif				/* !__x1f4_trans_type_defined__ */

#if !defined __x1f4_trans_type_defined__
# define __x1f4_trans_type_defined__
#endif				/* !__x1f4_trans_type_defined__ */

typedef struct x1f4_textport_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } textflat_set;
    struct {
	int type;
    } casttype_set;
    struct {
	int type;
    } lasttype_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } resource_set;
    struct {
	int (*call) (void *, struct x1f4_nodelink_type *),
	    (*fine) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *),
	    (*miss) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *);
	void *text;
    } missbail_set;
    struct {
	int *class;
    } autodeck_set;
    struct {
	const void *miss;
    } datatype_set;
    struct {
	const struct x1f4_lxtile_type *lxtile_data;
	unsigned miss;
    } tilelong_set;
    struct {
	const struct x1f4_nodetype_type *nodetype_data;
	unsigned miss;
    } nodetype_set;
    struct {
	const struct x1f4_operator_type *const *const *operator1s_set,
	    *const *const *operator2s_set;
    } operator_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned),
	    (*pick) (void *, void ***, int (*) (void *), unsigned, void **),
	    (*slip) (void *, void *, void *, int (*) (void *));
	void *data;
    } autolink_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } codelink_set;
} x1f4_textport_type;

#endif				/* __LIBx1f4_tp_H__ */
