/*
 * tcvs.x.c
 * Copyright (C) 2008-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <tcline.h>
#include <tcvs-defs.h>
#include <tcvs-names.h>
#include <tcvs-types.h>

extern const struct tccase_type _libx1f4l2_tcvs_i, _libx1f4l2_tcvs_o;

static int line_deck(void *, void *);

static int
line_deck(void *line, void *deck)
{
    struct tcnode_type *tcnode_data;
    unsigned ever;
    void **fine;
    const void *clip, **jset;

    fine = line;

    jset = *fine;

    tcnode_data = deck;

    clip = tcnode_data->data;
    ever = tcnode_data->ever;
    for (; ever; ever--) {
	*jset++ = clip;
    }

    *fine = jset;

    return 0;
}


int
_libx1f4l2_flat_tcvset(void **tcvset, const void **tccase, void *tcline,
		       struct trans_type *trans_data)
{
    int status;
    struct tcline_type *tcline_data;
    void *iset[4], **xset;

    tcline_data = tcline;

    xset = iset;
    x1f4_lime_tcline(tcline_data + 1, &xset, line_deck);

    status = x1f4_flat_tcline(tcline_data + 1);
    if (status) {
    } else {
	status = trans_data->free(trans_data->data, tcline_data);
	if (status) {
	    status = FREE_ERROR;
	} else {
	    void *data;

	    status = trans_data->link
		(trans_data->data, &data, sizeof(const void *) << 2);
	    if (status) {
		status = LINK_ERROR;

		*tcvset = NULL;

		*tccase = &_libx1f4l2_tcvs_i;
	    } else {
		const void **vset;

		*tcvset = data;

		vset = data;

		vset[0] = iset[0];
		vset[1] = iset[1];
		vset[2] = iset[2];
		vset[3] = iset[3];

		*tccase = &_libx1f4l2_tcvs_o;
	    }
	}
    }

    return status;
}
