/*
 * tcvs.v.c
 * Copyright (C) 2008-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <stddef.h>

#include <tcline.h>
#include <tcvs-defs.h>
#include <tcvs-names.h>
#include <tcvs-types.h>

#define integral_d(___p)		((integral_q) (___p))

#if SIZEOF_VOID_P == SIZEOF_LONG
# define integral_q			unsigned long
#else
# define integral_q			unsigned
#endif				/* SIZEOF_VOID_P == SIZEOF_LONG */

extern const struct tccase_type _libx1f4l2_tcvs_i, _libx1f4l2_tcvs_t;

static int deck_miss(void *deck, void *miss);

static int
deck_miss(void *deck, void *miss)
{
    int true;

    miss = *(void **) miss;

    if (integral_d(deck) < integral_d(miss)) {
	true = -1;
    } else {
	if (integral_d(miss) < integral_d(deck)) {
	    true = 1;
	} else {
	    true = 0;
	}
    }

    return true;
}


int
_libx1f4l2_fast_tcvset(void **tcvset, const void **tccase, const void *clip,
		       const void **deck, struct trans_type *trans_data)
{
    int status;
    const void *miss[4];

    miss[0] = deck[0];
    miss[1] = deck[1];
    miss[2] = deck[2];
    miss[3] = deck[3];

    status = trans_data->free(trans_data->data, deck);
    if (status) {
	status = FREE_ERROR;

	*tcvset = NULL;

	*tccase = &_libx1f4l2_tcvs_i;
    } else {
	unsigned e;
	void *data;

	x1f4_call_tcline(&e);

	status = trans_data->link
	    (trans_data->data, &data, sizeof(struct tcline_type) + e);
	if (status) {
	    status = LINK_ERROR;
	} else {
	    struct x1f4_tcline_type tcline;
	    void *line;

	    line = (struct tcline_type *) data + 1;

	    tcline.trans = trans_data;

	    status = x1f4_fast_tcline(line, X1f4_TCLINE_TRANS_MASK, &tcline);
	    if (status) {
	    } else {
		void *data;

		status = x1f4_post_tcline
		    (line, (void *) clip, deck_miss,
		     offsetof(struct tcnode_type, data),
		     sizeof(struct tcnode_type), &data);
		if (status) {
		    x1f4_flat_tcline(line);
		} else {
		    struct tcnode_type *tcnode_data;
		    unsigned i = 4;

		    tcnode_data = data;

		    tcnode_data->ever = 1;

		    tcnode_data->data = clip;

		    while (i) {
			--i;

			status = x1f4_post_tcline
			    (line, (void *) miss[i], deck_miss,
			     offsetof(struct tcnode_type, data),
			     sizeof(struct tcnode_type), &data);
			if (status) {
			    if (status == X1f4_TCLINE_EVER_MATCH) {
				((struct tcnode_type *) data)->ever++;

				status = 0;
			    } else {
				break;
			    }
			} else {
			    tcnode_data = data;

			    tcnode_data->ever = 1;

			    tcnode_data->data = miss[i];
			}
		    }

		    if (i) {
			x1f4_flat_tcline(line);
		    }
		}
	    }

	    if (status) {
		trans_data->free(trans_data->data, data);
	    } else {
		*tcvset = data;
		if (1) {
		    *tccase = &_libx1f4l2_tcvs_t;
		    if (1) {
			((struct tcline_type *) data)->data.size = 5;
		    }
		}
	    }
	}
    }

    return status;
}
