/*
 * tcvs.l.c
 * Copyright (C) 2008-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <stddef.h>

#include <tcvs-defs.h>
#include <tcvs-names.h>
#include <tcvs-types.h>

#define integral_d(___p)		((integral_q) (___p))

#if SIZEOF_VOID_P == SIZEOF_LONG
# define integral_q			unsigned long
#else
# define integral_q			unsigned
#endif				/* SIZEOF_VOID_P == SIZEOF_LONG */

extern const struct tccase_type _libx1f4l2_tcvs_o;

int
_libx1f4l2_fare_tcvset(void **tcvset, const void **tccase, const void *clip,
		       const void *deck, struct trans_type *trans_data)
{
    int status;
    void *data;

    status = trans_data->link
	(trans_data->data, &data, sizeof(const void *) << 2);
    if (status) {
	status = LINK_ERROR;
    } else {
	const void **vset;

	*tcvset = data;

	vset = data;

	if (integral_d(clip) < integral_d(deck)) {
	    vset[0] = clip;
	    vset[1] = deck;
	} else {
	    vset[0] = deck;
	    vset[1] = clip;
	}

	vset[2] = NULL;
	vset[3] = NULL;

	*tccase = &_libx1f4l2_tcvs_o;
    }

    return status;
}
