/*
 * tcvs.i.c
 * Copyright (C) 2008-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <tcvs-inter.h>
#include <tcvs-names.h>
#include <tcvs-types.h>

static int high_vset(void **, const void **, struct trans_type *);
static int lime_vset(void *, void *, int (*) (void *, void *));
static int miss_vset(void **, const void **, const void *,
		     struct trans_type *);
static int mode_vset(void **, const void *, const void *);
static int push_vset(void **, const void **, const void *,
		     struct trans_type *);
static int size_vset(void *, unsigned *);

const struct tccase_type _libx1f4l2_tcvs_i = {
/* *INDENT-OFF* */
    high_vset,
    lime_vset,
    miss_vset,
    mode_vset,
    push_vset,
    size_vset
/* *INDENT-ON* */
};

static int
high_vset(void **tcvset, const void **tccase, struct trans_type *trans_data)
{
    *tcvset = NULL;

    return 0;
}


static int
lime_vset(void *vset, void *back, int (*call) (void *, void *))
{
    int status;

    if (vset) {
	status = call(back, vset);
    } else {
	status = 0;
    }

    return status;
}


static int
miss_vset(void **tcvset, const void **tccase, const void *clip,
	  struct trans_type *trans_data)
{
    if (clip == *tcvset) {
	*tcvset = NULL;
    }

    return 0;
}


static int
mode_vset(void **tcvset, const void *miss, const void *push)
{
    if (miss == *tcvset) {
	*tcvset = (void *) push;
    }

    return 0;
}


static int
push_vset(void **tcvset, const void **tccase, const void *clip,
	  struct trans_type *trans_data)
{
    int status;
    void *vset;

    vset = *tcvset;
    if (vset) {
	status = _libx1f4l2_fare_tcvset
	    (tcvset, tccase, clip, vset, trans_data);
    } else {
	status = 0;

	*tcvset = (void *) clip;
    }

    return status;
}


static int
size_vset(void *vset, unsigned *size)
{
    if (vset) {
	*size = 1;
    } else {
	*size = 0;
    }

    return 0;
}
