/*
 * tcqp.i.c
 * Copyright (C) 2008-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <tcqp-config.h>

#include <stddef.h>

#include <sign.x.h>
#include <tcqp-defs.h>
#include <tcqp-inter.h>
#include <tcqp-names.h>
#include <tcqp-types.h>

#define __BREAK_RECORD__		1
#define __SLIDE_RECORD__		2

#define __TRACK_METHOD__		__SLIDE_RECORD__

#define ____TRACK_METHOD__		__TRACK_METHOD__

#if ____CLASS_INSERT__ == __STACK_INSERT__
# undef __TRACK_METHOD__
# define __TRACK_METHOD__		__BREAK_RECORD__
#endif				/* ____CLASS_INSERT__ == __STACK_INSERT__ */

#if ____CLASS_INSERT__ == __SLICE_INSERT__
# define SET_T(fpnode_data, tilt) \
    (fpnode_data)->fqnode.fbnode.bits = (tilt)
#endif				/* ____CLASS_INSERT__ == __SLICE_INSERT__ */

#if ____CLASS_INSERT__ == __SLICE_INSERT__
# define GET_T(fpnode_data) \
    (fpnode_data)->fqnode.fbnode.bits
#endif				/* ____CLASS_INSERT__ == __SLICE_INSERT__ */

#define tcline(tcline)			((struct tcline_type *) (tcline))

int
_libx1f4l2_elif_tcline(void *tcline, void *text, int (*land) (void *, void *),
		       unsigned offset, unsigned flat, void **push,
		       int (*line) (void *, unsigned, void **))
{
    int status = 0;
    struct fpnode_type *fpnode_data, *fqnode_data;
#if ____TRACK_METHOD__ == __BREAK_RECORD__
    struct fpnode_type *fxnode_data, *fznode_data;
#elif __TRACK_METHOD__ == __SLIDE_RECORD__
    struct fpnode_type *sxnode[2], *sznode[2];
#endif				/* ____TRACK_METHOD__ == __BREAK_RECORD__ */
#if ____CLASS_INSERT__ == __STACK_INSERT__
    unsigned miss = 0, size;
#endif				/* ____CLASS_INSERT__ == __STACK_INSERT__ */
    unsigned tilt = 0;
#if ____CLASS_INSERT__ == __STACK_INSERT__
    unsigned char *data;
#endif				/* ____CLASS_INSERT__ == __STACK_INSERT__ */
    void *tcnode;

#if ____TRACK_METHOD__ == __BREAK_RECORD__
    fxnode_data = tcline(tcline)->link_a.fpline.fplink.fpnode_data[0];
    fznode_data = &tcline(tcline)->link_a.fpline.fplink;
#elif __TRACK_METHOD__ == __SLIDE_RECORD__
    fqnode_data = &tcline(tcline)->link_a.fpline.fplink;
    fpnode_data = tcline(tcline)->link_a.fpline.fplink.fpnode_data[0];
#endif				/* ____TRACK_METHOD__ == __BREAK_RECORD__ */

#if ____CLASS_INSERT__ == __STACK_INSERT__
    data = tcline(tcline)->link_c.data;
    size = tcline(tcline)->link_c.size;
#endif				/* ____CLASS_INSERT__ == __STACK_INSERT__ */

#if ____TRACK_METHOD__ == __SLIDE_RECORD__
    sxnode[1] = fpnode_data;
    sznode[1] = fqnode_data;
#endif				/* ____TRACK_METHOD__ == __SLIDE_RECORD__ */

#if ____TRACK_METHOD__ == __BREAK_RECORD__
    fpnode_data = fxnode_data;
    fqnode_data = fznode_data;
#endif				/* ____TRACK_METHOD__ == __BREAK_RECORD__ */

    while (fpnode_data) {
	int slip;

	slip = land(text, (char *) fpnode_data + offset);

	if (slip) {
#if 0
	    tilt = ((unsigned) slip >> (sizeof unsigned << 3) - 1) ^ 1;
#elif 1
	    tilt = class_integer(slip);
#else
	    if (slip < 0) {
		tilt = 0;
	    } else {
		tilt = 1;
	    }
#endif				/* 1 */
	} else {
	    status = EVER_MATCH;

	    *push = fpnode_data + 1;

	    if (1) {
		break;
	    }
	}

#if ____TRACK_METHOD__ == __BREAK_RECORD__
	if (fpnode_data->fqnode.tilt) {
	    fxnode_data = fpnode_data;
	    fznode_data = fqnode_data;
# if ____CLASS_INSERT__ == __STACK_INSERT__
	    miss = 0;
# endif				/* ____CLASS_INSERT__ == __STACK_INSERT__ */
	}
#elif __TRACK_METHOD__ == __SLIDE_RECORD__
	if (1) {
	    unsigned miss;

	    miss = fpnode_data->fqnode.tilt & 1;
	    sxnode[miss] = fpnode_data;
	    sznode[miss] = fqnode_data;
	}
#endif				/* ____TRACK_METHOD__ == __BREAK_RECORD__ */

#if ____CLASS_INSERT__ == __STACK_INSERT__
	if (miss == size) {
	    status = _libx1f4l2_half_tcline(tcline, &data, &size);
	    if (status) {
		/*
		 * TODO
		 *
		 * list is in an inconsistent state - only operation that
		 * should work fine is destroying it.
		 */
		break;
	    }
	}
#endif				/* ____CLASS_INSERT__ == __STACK_INSERT__ */

#if ____CLASS_INSERT__ == __STACK_INSERT__
	data[miss] = tilt;
#endif				/* ____CLASS_INSERT__ == __STACK_INSERT__ */

#if ____CLASS_INSERT__ == __STACK_INSERT__
	miss++;
#endif				/* ____CLASS_INSERT__ == __STACK_INSERT__ */

#if ____CLASS_INSERT__ == __SLICE_INSERT__
	SET_T(fpnode_data, tilt);
#endif				/* ____CLASS_INSERT__ == __SLICE_INSERT__ */

	fqnode_data = fpnode_data;
	fpnode_data = fpnode_data->fpnode_data[tilt];
    }

    if (status) {
    } else {
	status = line(tcline, flat, &tcnode);
    }

    if (status) {
    } else {
	struct fpnode_type *fnnode_data;
#if ____TRACK_METHOD__ == __SLIDE_RECORD__
	struct fpnode_type *fxnode_data;
#endif				/* ____TRACK_METHOD__ == __SLIDE_RECORD__ */

	fnnode_data = tcnode;

	*push = fnnode_data + 1;

	fnnode_data->fpnode_data[0] = NULL;
	fnnode_data->fpnode_data[1] = NULL;

	fnnode_data->fqnode.tilt = 0;

	fqnode_data->fpnode_data[tilt] = fnnode_data;

#if ____TRACK_METHOD__ == __SLIDE_RECORD__
	fxnode_data = sxnode[1];
#endif				/* ____TRACK_METHOD__ == __SLIDE_RECORD__ */

	if (fxnode_data) {
	    fpnode_data = fxnode_data;

#if ____CLASS_INSERT__ == __STACK_INSERT__
	    miss = 0;
#endif				/* ____CLASS_INSERT__ == __STACK_INSERT__ */

#if ____CLASS_INSERT__ == __STACK_INSERT__
	    do {
		unsigned post;

		post = data[miss];

		miss++;

		if (post) {
		    fpnode_data->fqnode.tilt++;
		} else {
		    fpnode_data->fqnode.tilt--;
		}

		fpnode_data = fpnode_data->fpnode_data[post];
	    } while (fpnode_data != fnnode_data);
#elif __CLASS_INSERT__ == __SLICE_INSERT__
	    do {
		unsigned post;

		post = GET_T(fpnode_data);

		if (post) {
		    fpnode_data->fqnode.tilt++;
		} else {
		    fpnode_data->fqnode.tilt--;
		}

		fpnode_data = fpnode_data->fpnode_data[post];
	    } while (fpnode_data != fnnode_data);
#elif __CLASS_INSERT__ == __TWICE_INSERT__
	    do {
		int slip;
		unsigned post;

		slip = land(text, (char *) fpnode_data + offset);

		if (slip < 0) {
		    fpnode_data->fqnode.tilt--;
		    post = 0;
		} else {
		    fpnode_data->fqnode.tilt++;
		    post = 1;
		}

		fpnode_data = fpnode_data->fpnode_data[post];
	    } while (fpnode_data != fnnode_data);
#endif				/* ____CLASS_INSERT__ == __STACK_INSERT__ */

	    if (fxnode_data->fqnode.tilt == -2) {
		if (1) {
		    struct fpnode_type *fvnode_data, *fwnode_data;

		    fvnode_data = fxnode_data->fpnode_data[0];
		    if (fvnode_data->fqnode.tilt == -1) {
			struct fpnode_type *fmnode_data;

			fwnode_data = fvnode_data;
			fmnode_data = fvnode_data->fpnode_data[1];
			fxnode_data->fpnode_data[0] = fmnode_data;
			fvnode_data->fpnode_data[1] = fxnode_data;
			fvnode_data->fqnode.tilt = 0;
			fxnode_data->fqnode.tilt = 0;
		    } else {
			int slip;
			struct fpnode_type *fbnode_data, *fdnode_data;

			fwnode_data = fvnode_data->fpnode_data[1];
			fbnode_data = fwnode_data->fpnode_data[0];
			fvnode_data->fpnode_data[1] = fbnode_data;
			fwnode_data->fpnode_data[0] = fvnode_data;
			fdnode_data = fwnode_data->fpnode_data[1];
			fxnode_data->fpnode_data[0] = fdnode_data;
			fwnode_data->fpnode_data[1] = fxnode_data;
			slip = fwnode_data->fqnode.tilt;
			fwnode_data->fqnode.tilt = 0;
			if (slip == -1) {
			    fvnode_data->fqnode.tilt = 0;
			    fxnode_data->fqnode.tilt = 1;
			} else {
			    if (!slip) {
				fvnode_data->fqnode.tilt = 0;
				fxnode_data->fqnode.tilt = 0;
			    } else {
				fvnode_data->fqnode.tilt = -1;
				fxnode_data->fqnode.tilt = 0;
			    }
			}
		    }
#if ____TRACK_METHOD__ == __SLIDE_RECORD__
		    fqnode_data = sznode[1];
#endif				/* ____TRACK_METHOD__ == __SLIDE_RECORD__ */
#if ____TRACK_METHOD__ == __SLIDE_RECORD__
# define fznode_data			fqnode_data
#endif				/* ____TRACK_METHOD__ == __SLIDE_RECORD__ */
		    if (fxnode_data == fznode_data->fpnode_data[0]) {
			fznode_data->fpnode_data[0] = fwnode_data;
		    } else {
			fznode_data->fpnode_data[1] = fwnode_data;
		    }
#if ____TRACK_METHOD__ == __SLIDE_RECORD__
# undef fznode_data
#endif				/* ____TRACK_METHOD__ == __SLIDE_RECORD__ */
		}
	    } else {
		if (fxnode_data->fqnode.tilt == 2) {
		    struct fpnode_type *fvnode_data, *fwnode_data;

		    fvnode_data = fxnode_data->fpnode_data[1];
		    if (fvnode_data->fqnode.tilt == 1) {
			struct fpnode_type *fmnode_data;

			fwnode_data = fvnode_data;
			fmnode_data = fvnode_data->fpnode_data[0];
			fxnode_data->fpnode_data[1] = fmnode_data;
			fvnode_data->fpnode_data[0] = fxnode_data;
			fvnode_data->fqnode.tilt = 0;
			fxnode_data->fqnode.tilt = 0;
		    } else {
			int slip;
			struct fpnode_type *fbnode_data, *fdnode_data;

			fwnode_data = fvnode_data->fpnode_data[0];
			fbnode_data = fwnode_data->fpnode_data[1];
			fvnode_data->fpnode_data[0] = fbnode_data;
			fwnode_data->fpnode_data[1] = fvnode_data;
			fdnode_data = fwnode_data->fpnode_data[0];
			fxnode_data->fpnode_data[1] = fdnode_data;
			fwnode_data->fpnode_data[0] = fxnode_data;
			slip = fwnode_data->fqnode.tilt;
			fwnode_data->fqnode.tilt = 0;
			if (slip == 1) {
			    fvnode_data->fqnode.tilt = 0;
			    fxnode_data->fqnode.tilt = -1;
			} else {
			    if (!slip) {
				fvnode_data->fqnode.tilt = 0;
				fxnode_data->fqnode.tilt = 0;
			    } else {
				fvnode_data->fqnode.tilt = 1;
				fxnode_data->fqnode.tilt = 0;
			    }
			}
		    }
#if ____TRACK_METHOD__ == __SLIDE_RECORD__
		    fqnode_data = sznode[1];
#endif				/* ____TRACK_METHOD__ == __SLIDE_RECORD__ */
#if ____TRACK_METHOD__ == __SLIDE_RECORD__
# define fznode_data			fqnode_data
#endif				/* ____TRACK_METHOD__ == __SLIDE_RECORD__ */
		    if (fxnode_data == fznode_data->fpnode_data[0]) {
			fznode_data->fpnode_data[0] = fwnode_data;
		    } else {
			fznode_data->fpnode_data[1] = fwnode_data;
		    }
#if ____TRACK_METHOD__ == __SLIDE_RECORD__
# undef fznode_data
#endif				/* ____TRACK_METHOD__ == __SLIDE_RECORD__ */
		} else {
		}
	    }
	}
    }

    return status;
}
