/*
 * tcqp.f.c
 * Copyright (C) 2008-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <tcqp-config.h>

#include <stddef.h>

#include <mask.0.h>
#include <tcqp-defs.h>
#include <tcqp-names.h>
#include <tcqp-types.h>
#include <trans.h>

#if ____ELINK_TARGET__
# define __XLINK_TARGET__		1
#elif __QLINK_TARGET__
# define __XLINK_TARGET__		1
#else
# define __XLINK_TARGET__		0
#endif				/* ____ELINK_TARGET__ */

#define ____XLINK_TARGET__		__XLINK_TARGET__

#if ____XLINK_TARGET__
# define __ZLINK_TARGET__		0
#else
# define __ZLINK_TARGET__		1
#endif				/* ____XLINK_TARGET__ */

#define tcline(tcline)			((struct tcline_type *) (tcline))

#if __QLINK_TARGET__
static int free_ceil(struct tcline_type *);
#endif				/* __QLINK_TARGET__ */
#if __XLINK_TARGET__
static int init_line(struct tcline_type *);
#endif				/* __XLINK_TARGET__ */
#if __QLINK_TARGET__
static int link_ceil(struct tcline_type *);
#endif				/* __QLINK_TARGET__ */
#if __ELINK_TARGET__
static int link_lock(struct tcline_type *);
#endif				/* __ELINK_TARGET__ */

#if __QLINK_TARGET__
static int
free_ceil(struct tcline_type *tcline_data)
{
    int status;
    void *data;

    data = tcline_data->link_c.data;

    if (data) {
	status = tcline_data->link_m.free(tcline_data->link_m.data, data);
	if (status) {
	    status = FREE_ERROR;
	}
    } else {
	status = 0;
    }

    return status;
}
#endif				/* __QLINK_TARGET__ */


#if __XLINK_TARGET__
static int
init_line(struct tcline_type *tcline_data)
{
    int status;
#endif				/* __XLINK_TARGET__ */

#if __QLINK_TARGET__
    status = link_ceil(tcline_data);
    if (status) {
    } else {
#endif				/* __QLINK_TARGET__ */
#if __ELINK_TARGET__
	status = link_lock(tcline_data);
#endif				/* __ELINK_TARGET__ */

#if __QLINK_TARGET__
	if (status) {
	    free_ceil(tcline_data);
	}
    }
#endif				/* __QLINK_TARGET__ */

#if __XLINK_TARGET__
    return status;
}
#endif				/* __XLINK_TARGET__ */


#if __QLINK_TARGET__
static int
link_ceil(struct tcline_type *tcline_data)
{
    int status;
    void *data;

    status = tcline_data->link_m.link(tcline_data->link_m.data, &data, 32);
    if (status) {
	status = LINK_ERROR;
    } else {
	tcline_data->link_c.data = data;
	tcline_data->link_c.size = 0040;
    }

    return status;
}
#endif				/* __QLINK_TARGET__ */


#if __ELINK_TARGET__
static int
link_lock(struct tcline_type *tcline_data)
{
    int status;
    void *data;

    status = tcline_data->link_m.link
	(tcline_data->link_m.data, &data, sizeof(struct fpnode_type *) << 4);
    if (status) {
	status = LINK_ERROR;
    } else {
	tcline_data->link_e.fpmiss = data;
	tcline_data->link_e.seek = 000020;
    }

    return status;
}
#endif				/* __ELINK_TARGET__ */


int
x1f4_fast_tcline(void *tcline, unsigned flags,
		 struct screen_type *screen_data)
{
#if __XLINK_TARGET__
    int status;
#endif				/* __XLINK_TARGET__ */

    if (0) {
    } else {
	tcline(tcline)->link_a.fpline.fplink.fpnode_data[0] = NULL;

#if __QLINK_TARGET__
	if (0) {
	    tcline(tcline)->link_c.data = NULL;
	}
#endif				/* __QLINK_TARGET__ */

#if __ELINK_TARGET__
	if (0) {
	    tcline(tcline)->link_e.fpmiss = NULL;
	}
#endif				/* __ELINK_TARGET__ */

	if (flags & TRANS_MASK) {
	    struct trans_type *trans_data;

	    trans_data = screen_data->trans_data;

	    tcline(tcline)->link_m.data = trans_data->data;
	    tcline(tcline)->link_m.free = trans_data->free;
	    tcline(tcline)->link_m.link = trans_data->link;
	    tcline(tcline)->link_m.mode = trans_data->mode;
	} else {
	    tcline(tcline)->link_m.free = _libx1f4l2_free_data;
	    tcline(tcline)->link_m.link = _libx1f4l2_link_data;
	    tcline(tcline)->link_m.mode = _libx1f4l2_mode_data;
	}

#if __XLINK_TARGET__
	status = init_line(tcline);
	if (status) {
	} else {
	}
#endif				/* __XLINK_TARGET__ */
    }

#if __ZLINK_TARGET__
    return 0;
#else
    return status;
#endif				/* __ZLINK_TARGET__ */
}
