/*
 * tcqp.b.c
 * Copyright (C) 2008-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <tcqp-names.h>
#include <tcqp-types.h>

#define Delete				0

#define tcline(tcline)			((struct tcline_type *) (tcline))

static int back_node(struct fpnode_type *, void *,
		     int (*) (void *, void *, unsigned), unsigned);

static int
back_node(struct fpnode_type *fpnode_data, void *back,
	  int (*call) (void *, void *, unsigned), unsigned scan)
{
    int delete;

    do {
	struct fpnode_type *fqnode_data;

	fqnode_data = fpnode_data->fpnode_data[0];
	if (fqnode_data) {
	    delete = back_node(fqnode_data, back, call, scan + 1);
	    if (delete) {
		break;
	    }
	}

	if (1) {
	    delete = call(back, fpnode_data + 1, scan);
	    if (delete) {
		break;
	    }
	}

	fqnode_data = fpnode_data->fpnode_data[1];
	if (fqnode_data) {
	    delete = back_node(fqnode_data, back, call, scan + 1);
	    if (Delete) {
		break;
	    }
	}
    } while (0);

    return delete;
}


int
x1f4_scan_tcline(void *tcline, void *back,
		 int (*call) (void *, void *, unsigned))
{
    int delete;
    struct fpnode_type *fpnode_data;

    fpnode_data = tcline(tcline)->link_a.fpline.fplink.fpnode_data[0];
    if (fpnode_data) {
	delete = back_node(fpnode_data, back, call, 0);
    } else {
	delete = 0;
    }

    return delete;
}
