/*
 * tcqp.4.c
 * Copyright (C) 2008-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <sign.x.h>
#include <tcqp-names.h>
#include <tcqp-types.h>

#define tcline(tcline)			((struct tcline_type *) (tcline))

static int find_list(struct fpnode_type *, void *, unsigned,
		     int (*) (void *, void *), void **);

static int
find_list(struct fpnode_type *fpnode_data, void *text, unsigned offset,
	  int (*land) (void *, void *), void **find)
{
    int delete;

    offset += sizeof(struct fpnode_type);

    while (1) {
	int slip;

	slip = land(text, (char *) fpnode_data + offset);
	if (!slip) {
	    delete = 1;

	    *find = fpnode_data + 1;

	    break;
	} else {
#if 1
	    fpnode_data = fpnode_data->fpnode_data[class_integer(slip)];
	    if (fpnode_data) {
	    } else {
		delete = 0;
		if (1) {
		    break;
		}
	    }
#else
	    if (slip < 0) {
		fpnode_data = fpnode_data->fpnode_data[0];
		if (fpnode_data) {
		} else {
		    delete = 0;
		    if (1) {
			break;
		    }
		}
	    } else {
		fpnode_data = fpnode_data->fpnode_data[1];
		if (fpnode_data) {
		} else {
		    delete = 0;
		    if (1) {
			break;
		    }
		}
	    }
#endif				/* 1 */
	}
    }

    return delete;
}


int
x1f4_find_tcline(void *tcline, void *text, unsigned slip,
		 int (*land) (void *, void *), void **find)
{
    int delete;
    void *miss;

    miss = tcline(tcline)->link_a.fpline.fplink.fpnode_data[0];
    if (miss) {
	delete = find_list(miss, text, slip, land, find);
    } else {
	delete = 0;
    }

    return delete;
}
