/*
 * tcqb.9.c
 * Copyright (C) 2008-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <tcqp-defs.h>
#include <tcqp-inter.h>
#include <tcqp-names.h>
#include <tcqp-types.h>

#define tcline(tcline)			((struct tcline_type *) (tcline))

typedef struct back_type {
    int (*call) (void *, void *);
    void *back, *line;
} back_type;

static int shut_line(void *, void *);

static int
shut_line(void *back, void *tcnode)
{
    int status;

    if (((struct back_type *) back)->call
	(((struct back_type *) back)->back,
	 ((struct fpnode_type *) tcnode) + 1)) {
	status = CALL_ERROR;
    } else {
	struct tcline_type *tcline_data;

	tcline_data = ((struct back_type *) back)->line;
	status = tcline_data->link_m.free(tcline_data->link_m.data, tcnode);
	if (status) {
	    status = FREE_ERROR;
	}
    }

    return status;
}


int
x1f4_shut_tcline(void *tcline, void *text, int (*land) (void *, void *),
		 unsigned offset, void *back, int (*call) (void *, void *))
{
    int status;

    if (tcline(tcline)->link_a.fpline.fplink.fpnode_data[0]) {
	struct back_type nand;

	nand.line = tcline;

	nand.back = back;
	nand.call = call;

	status = _libx1f4l2_nand_tcline
	    (tcline, text, land, sizeof(struct fpnode_type) + offset, &nand,
	     shut_line);
	if (status) {
	    if (status == CALL_ERROR) {
		status = 0;
	    }
	}
    } else {
	status = MISS_CLASS;
    }

    return status;
}
