/*
 * tcqb.4.c
 * Copyright (C) 2008-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <tcqp-names.h>
#include <tcqp-types.h>

#define d_count				(SIZEOF_UNSIGNED << 3)

#define d_left				(d_count - 1)

#define d_high				(1u << d_left)

#define tcline(tcline)			((struct tcline_type *) (tcline))

static int find_d1db(struct fpnode_type *, unsigned, unsigned, void **);
static int find_d1dp(struct fpnode_type *, unsigned, unsigned, void **);
static int find_d1qb(struct fpnode_type *, unsigned, unsigned, void **);
static int find_d1qp(struct fpnode_type *, unsigned, unsigned, void **);

static int
find_d1db(struct fpnode_type *fpnode_data, unsigned text, unsigned offset,
	  void **find)
{
    int delete;

    while (1) {
	unsigned diff, slip;

	slip = *(unsigned *) ((char *) fpnode_data + offset);

	diff = slip - text;
	if (!diff) {
	    delete = 1;

	    *find = fpnode_data + 1;

	    break;
	} else {
	    fpnode_data = fpnode_data->fpnode_data[diff >> d_left];
	    if (fpnode_data) {
	    } else {
		delete = 0;
		if (1) {
		    break;
		}
	    }
	}
    }

    return delete;
}


static int
find_d1dp(struct fpnode_type *fpnode_data, unsigned text, unsigned offset,
	  void **find)
{
    int delete;

    while (1) {
	unsigned slip;

	slip = *(unsigned *) ((char *) fpnode_data + offset);

	if (slip & d_high) {
	    unsigned diff;

	    diff = slip - text;

	    if (diff >> d_left) {
		fpnode_data = fpnode_data->fpnode_data[1];
		if (fpnode_data) {
		    delete = find_d1db(fpnode_data, text, offset, find);
		    if (1) {
			break;
		    }
		} else {
		    delete = 0;
		    if (1) {
			break;
		    }
		}
	    } else {
		if (!diff) {
		    delete = 1;

		    *find = fpnode_data + 1;

		    break;
		} else {
		    fpnode_data = fpnode_data->fpnode_data[0];
		    if (fpnode_data) {
		    } else {
			delete = 0;
			if (1) {
			    break;
			}
		    }
		}
	    }
	} else {
	    fpnode_data = fpnode_data->fpnode_data[1];
	    if (fpnode_data) {
	    } else {
		delete = 0;
		if (1) {
		    break;
		}
	    }
	}
    }

    return delete;
}


static int
find_d1qb(struct fpnode_type *fpnode_data, unsigned text, unsigned offset,
	  void **find)
{
    int delete;

    while (1) {
	unsigned diff, slip;

	slip = *(unsigned *) ((char *) fpnode_data + offset);

	diff = slip - text;
	if (!diff) {
	    delete = 1;

	    *find = fpnode_data + 1;

	    break;
	} else {
	    fpnode_data = fpnode_data->fpnode_data[diff >> d_left];
	    if (fpnode_data) {
	    } else {
		delete = 0;
		if (1) {
		    break;
		}
	    }
	}
    }

    return delete;
}


static int
find_d1qp(struct fpnode_type *fpnode_data, unsigned text, unsigned offset,
	  void **find)
{
    int delete;

    while (1) {
	unsigned slip;

	slip = *(unsigned *) ((char *) fpnode_data + offset);

	if (slip & d_high) {
	    fpnode_data = fpnode_data->fpnode_data[0];
	    if (fpnode_data) {
	    } else {
		delete = 0;
		if (1) {
		    break;
		}
	    }
	} else {
	    unsigned diff;

	    diff = slip - text;

	    if (diff >> d_left) {
		fpnode_data = fpnode_data->fpnode_data[1];
		if (fpnode_data) {
		} else {
		    delete = 0;
		    if (1) {
			break;
		    }
		}
	    } else {
		if (!diff) {
		    delete = 1;

		    *find = fpnode_data + 1;

		    break;
		} else {
		    fpnode_data = fpnode_data->fpnode_data[0];
		    if (fpnode_data) {
			delete = find_d1qb(fpnode_data, text, offset, find);
			if (1) {
			    break;
			}
		    } else {
			delete = 0;
			if (1) {
			    break;
			}
		    }
		}
	    }
	}
    }

    return delete;
}


int
x1f4_find_tcfine(void *tcline, unsigned text, unsigned slip, void **find)
{
    int delete;
    void *miss;

    miss = tcline(tcline)->link_a.fpline.fplink.fpnode_data[0];
    if (miss) {
	if (text & d_high) {
	    delete = find_d1dp
		(miss, text, slip + sizeof(struct fpnode_type), find);
	} else {
	    delete = find_d1qp
		(miss, text, slip + sizeof(struct fpnode_type), find);
	}
    } else {
	delete = 0;
    }

    return delete;
}
