/*
 * tcqb.1.c
 * Copyright (C) 2008-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <tcqp-defs.h>
#include <tcqp-inter.h>
#include <tcqp-names.h>
#include <tcqp-types.h>

#define tcline(tcline)			((struct tcline_type *) (tcline))

int
x1f4_cast_tcline(void *tcline, void *text, int (*land) (void *, void *),
		 unsigned offset)
{
    int status;

    if (tcline(tcline)->link_a.fpline.fplink.fpnode_data[0]) {
	status = _libx1f4l2_nand_tcline
	    (tcline, text, land, sizeof(struct fpnode_type) + offset, tcline,
	     _libx1f4l2_dana_tcline);
    } else {
	status = MISS_CLASS;
    }

    return status;
}
