/*
 * sshell.h
 * Copyright (C) 2006-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_SSHELL_H__
#define __LIBx1f4_SSHELL_H__

#include <sshell-names.h>

#define X1f4_SSHELL_ARGV_MASK		(1u << 0x00)
#define X1f4_SSHELL_BACK_MASK		(1u << 0x01)
#define X1f4_SSHELL_C3RD_MASK		(1u << 0x02)
#define X1f4_SSHELL_CALL_MASK		(1u << 0x03)
#define X1f4_SSHELL_DATA_MASK		(1u << 0x04)
#define X1f4_SSHELL_E1ST_MASK		(1u << 0x05)
#define X1f4_SSHELL_E6TH_MASK		(1u << 0x06)
#define X1f4_SSHELL_HEAD_MASK		(1u << 0x07)
#define X1f4_SSHELL_LINE_MASK		(1u << 0x08)
#define X1f4_SSHELL_LOOK_MASK		(1u << 0x09)
#define X1f4_SSHELL_MASK_MASK		(1u << 0x0a)
#define X1f4_SSHELL_PATH_MASK		(1u << 0x0b)
#define X1f4_SSHELL_SIZE_MASK		(1u << 0x0c)
#define X1f4_SSHELL_TAIL_MASK		(1u << 0x0d)
#define X1f4_SSHELL_TEXT_MASK		(1u << 0x0e)
#define X1f4_SSHELL_TYPE_MASK		(1u << 0x0f)

#define X1f4_SSHELL_KILL_C3RD		0
#define X1f4_SSHELL_MISS_C3RD		1
#define X1f4_SSHELL_NULL_C3RD		2

#define X1f4_SSHELL_CELL_SLIP		-32
#define X1f4_SSHELL_EXIT_SLIP		-33
#define X1f4_SSHELL_FLOW_SLIP		-34
#define X1f4_SSHELL_FORK_SLIP		-35
#define X1f4_SSHELL_LINE_SLIP		-36
#define X1f4_SSHELL_LOCK_SLIP		-37
#define X1f4_SSHELL_MASK_SLIP		-38
#define X1f4_SSHELL_NEAR_SLIP		-39
#define X1f4_SSHELL_PIPE_SLIP		-40
#define X1f4_SSHELL_POLL_SLIP		-41
#define X1f4_SSHELL_READ_SLIP		-42
#define X1f4_SSHELL_WAIT_SLIP		-43

typedef struct x1f4_ssrecord_type {
    union {
	struct {
	    int status;
	} exit;
    } collect;
} x1f4_ssrecord_type;

typedef struct x1f4_sshell_type {
    struct {
	int (*line) (void *, const void *, unsigned);
	void *text;
    } channel;
    struct {
	int (*call) (void *);
	void *back;
    } cleanup;
    struct {
	const char *const *argv, *path;
    } command;
    struct {
	int (*head) (void *), (*tail) (void *),
	    (*type) (void *, const char *, unsigned);
	void *look;
    } printer;
    struct {
	char *data;
	unsigned size;
    } storage;
    struct {
	unsigned e1st, e6th;
    } timeout;
    struct {
	unsigned c3rd, mask;
    } trailer;
    struct x1f4_ssrecord_type address;
} x1f4_sshell_type;

extern int x1f4_fini_sshell(void **);
extern int x1f4_init_sshell(void **);
extern int x1f4_link_sshell(void *, char **, unsigned *);
extern int x1f4_mode_sshell(void *, struct x1f4_sshell_type *, unsigned);
extern int x1f4_stat_sshell(void *, int);

#endif				/* __LIBx1f4_SSHELL_H__ */
