/*
 * sshell-types.h
 * Copyright (C) 2006-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_SSHELL_TYPES_H__
#define __LIBx1f4_SSHELL_TYPES_H__

typedef struct effect_type {
    union {
	struct {
	    int status;
	} exit;
    } collect;
} effect_type;

typedef struct record_type {
    struct {
	int (*line) (void *, const void *, unsigned);
	void *text;
    } channel;
    struct {
	int (*call) (void *);
	void *back;
    } cleanup;
    struct {
	int fd_0, wait;
	void (*chld) (int);
    } context;
    struct {
	const char *const *argv, *path;
    } command;
    struct {
	int (*head) (void *), (*tail) (void *),
	    (*type) (void *, const char *, unsigned);
	void *look;
    } printer;
    struct {
	char *data;
	unsigned size;
    } storage;
    struct {
	unsigned e1st, e6th;
    } timeout;
    struct {
	unsigned c3rd, mask;
    } trailer;
    struct effect_type address;
} record_type;

#endif				/* __LIBx1f4_SSHELL_TYPES_H__ */
