/*
 * space.v.c
 * Copyright (C) 2006-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

static const char f_space[] = "                ";

int
x1f4_vprint_space(void *data, int (*this) (void *, const char *, unsigned),
		  unsigned space)
{
    int status = 0;

    while (space & ~15) {
	space -= 16;
	status = this(data, f_space, 16);
	if (status) {
	    space = 0;
	}
    }
    if (space) {
	status = this(data, f_space, space);
    }

    return status;
}
