/*
 * sfax.v.c
 * Copyright (C) 2009-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <sfas-names.h>
#include <sfas-patch.h>
#include <sfas-types.h>

#define back(miss)			((const char *) (miss))
#define fast(miss)			((const byte *) (miss))

#define sfnote(sfnote)			((struct sfnote_type *) (sfnote))

int
x1f4_fgxq_sfnote(void *sfnote, const char *seek, void **data,
		 const char **name, unsigned *size)
{
    int delete;
    const struct fpnode_type *fpnode_data;

    fpnode_data = sfnote(sfnote)->link_a.fpdeck.fpnode_data;
    if (fpnode_data) {
	const struct fpnode_type *fpnode_pick = NULL;

	do {
	    const char *lead;
	    byte *slip;
	    int e;
	    unsigned bits, length;

	    bits = fpnode_data->bits;

	    lead = seek;

	    e = Prefix(bits);
	    if (e) {
		int c;

		c = *fast(seek);
		if (e < c) {
		    break;
		} else {
		    if (c ^ e) {
			fpnode_pick = fpnode_data;
			if (1) {
			    break;
			}
		    } else {
			seek++;
			length = length(fpnode_data);
			if (Extant(bits)) {
			    if (sizeof(byte *) < length) {
				slip = fpnode_data->base;
				if (length < Record) {
				} else {
				    length += strlen(back(slip) + Record);
				}
			    } else {
				slip = (byte *) &fpnode_data->base;
			    }
			} else {
			    slip = fpnode_data->base;

			    if (length < Record) {
			    } else {
				length += strlen(back(slip) + Record);
			    }

			    slip++;
			    length--;
			}
		    }
		}
	    } else {
		length = 0;
		slip = NULL;
	    }

	    while (1) {
		int c;

		c = *fast(seek);
		if (c) {
		    seek++;
		    if (length) {
			e = *slip;
			if (c == e) {
			    length--;
			    slip++;
			} else {
			    if (c < e) {
				fpnode_pick = fpnode_data;
			    }

			    break;
			}
		    } else {
			if (Extant(bits)) {
			    const struct fpnode_type *fpnode_slip;
			    unsigned effect;

			    effect = Effect(bits);

			    fpnode_slip = fpnode_data->data;
			    fpnode_data = fpnode_slip;

			    Progress_node(fpnode_data, effect);

			    e = prefix(fpnode_data);
			    if (e ^ c) {
				if (e < c) {
				    if ((fpnode_data - fpnode_slip) ^ effect) {
					fpnode_pick = fpnode_data + 1;
				    }
				} else {
				    fpnode_pick = fpnode_data;
				}

				break;
			    } else {
				bits = fpnode_data->bits;

				length = Length(bits);

				if (Extant(bits)) {
				    if (sizeof(byte *) < length) {
					slip = fpnode_data->base;
					if (length < Record) {
					} else {
					    length +=
						strlen(back(slip) + Record);
					}
				    } else {
					slip = (byte *) &fpnode_data->base;
				    }
				} else {
				    unsigned offset;

				    slip = fpnode_data->base;

				    if (length < Record) {
				    } else {
					length += strlen(back(slip) + Record);
				    }

				    offset = seek - lead;
				    slip += offset;
				    length -= offset;
				}

				if (1) {
				    if ((fpnode_data - fpnode_slip) ^ effect) {
					fpnode_pick = fpnode_data + 1;
				    }
				}
			    }
			} else {
			    break;
			}
		    }
		} else {
		    if (extant(fpnode_data)) {
			fpnode_pick = fpnode_data->data;
			if (length) {
			} else {
			    if (prefix(fpnode_pick)) {
			    } else {
				fpnode_pick++;
			    }
			}
		    } else {
			if (length) {
			    fpnode_pick = fpnode_data;
			} else {
			}
		    }

		    break;
		}
	    }
	} while (0);

	if (fpnode_pick) {
	    delete = 1;

	    while (1) {
		unsigned bits;

		bits = fpnode_pick->bits;
		if (Extant(bits)) {
		    fpnode_pick = fpnode_pick->data;
		} else {
		    unsigned copy;
		    void *text;

		    text = fpnode_pick->base;

		    copy = Length(bits);
		    if (copy < Record) {
		    } else {
			copy += strlen((char *) text + Record);
		    }

		    *data = fpnode_pick->data;
		    *name = text;
		    *size = copy;

		    break;
		}
	    }
	} else {
	    delete = 0;
	}
    } else {
	delete = 0;
    }

    return delete;
}
