/*
 * sfas.y.c
 * Copyright (C) 2009-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <sfas-defs.h>
#include <sfas-names.h>
#include <sfas-types.h>

#define sfnote(sfnote)			((struct sfnote_type *) (sfnote))

int
_libx1f4l2_fail_sfnote(void *sfnote, struct fpnode_type *fpnode_data)
{
    int status;

    do {
	status = sfnote(sfnote)->link_m.free
	    (sfnote(sfnote)->link_m.data, fpnode_data->data);
	if (status) {
	    status = FREE_ERROR;

	    break;
	}

	status = sfnote(sfnote)->link_m.free
	    (sfnote(sfnote)->link_m.data, fpnode_data);
	if (status) {
	    status = FREE_ERROR;
	} else {
	}

	sfnote(sfnote)->link_a.fpdeck.fpnode_data = NULL;
    } while (0);

    return status;
}
