/*
 * sfas.j.c
 * Copyright (C) 2009-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <sfas-defs.h>
#include <sfas-names.h>
#include <sfas-types.h>

#define back(miss)			((const char *) (miss))

#define sfnote(sfnote)			((struct sfnote_type *) (sfnote))

static int pass_link(void *, struct fpnode_type *, struct fpnode_type *);
static int pass_name(void *, struct fpnode_type *, struct fpnode_type *);

static int
pass_link(void *sfnote, struct fpnode_type *fpnode_slip,
	  struct fpnode_type *fpnode_data)
{
    byte *base, *lock;
    int prefix, status;
    unsigned bits, length, miss, offset;

    bits = fpnode_slip->bits;

    base = fpnode_slip->base;

    length = Length(bits);
    if (length < Record) {
    } else {
	length += strlen(back(base) + Record);
    }

    if (fpnode_data == fpnode_slip->data) {
	fpnode_data++;
    } else {
	fpnode_data--;
    }

    prefix = Prefix(bits);

    miss = fpnode_data->bits;

    lock = fpnode_data->base;

    if (prefix) {
	if (Extant(miss)) {
	    if (Prefix(miss)) {
		offset = Length(miss);
		if (offset < Record) {
		    if (sizeof(byte *) < offset) {
		    } else {
			lock = (byte *) &fpnode_data->base;
		    }
		} else {
		    offset += strlen(back(lock) + Record);
		}

		offset++;
	    } else {
		offset = 0;
	    }
	} else {
	    offset = 0;
	}
    } else {
	offset = 0;
    }

    if (offset) {
	{
	    unsigned mirror;
	    void *copy;

	    mirror = length + offset;

	    if (sizeof(byte *) < mirror) {
		if (sizeof(byte *) < length) {
		    copy = base;
		    status = sfnote(sfnote)->link_m.mode
			(sfnote(sfnote)->link_m.data, &copy, mirror + 1);
		    if (status) {
			status = MODE_ERROR;
		    } else {
			fpnode_slip->base = copy;
		    }
		} else {
		    status = sfnote(sfnote)->link_m.link
			(sfnote(sfnote)->link_m.data, &copy, mirror + 1);
		    if (status) {
			status = LINK_ERROR;
		    } else {
			fpnode_slip->base = copy;
			memcpy(copy, &fpnode_slip->base, length);
		    }
		}
	    } else {
		copy = &fpnode_slip->base;
		if (1) {
		    status = 0;
		}
	    }
	    if (status) {
		sfnote(sfnote)->link_m.free
		    (sfnote(sfnote)->link_m.data, (void *) fpnode_slip->data);
		if (sizeof(byte *) < length) {
		    sfnote(sfnote)->link_m.free
			(sfnote(sfnote)->link_m.data, base);
		}

		*fpnode_slip = *fpnode_data;
	    } else {
		byte *deck;
		void *slip;

		deck = copy;
		deck += length;
		*deck = Prefix(miss);
		deck++;
		offset--;
		if (offset) {
		    memcpy(deck, lock, offset);
		    if (1) {
			deck += offset;
		    }
		}

		if (sizeof(byte *) < mirror) {
		    *deck = 0;
		}

		slip = (void *) fpnode_slip->data;

		fpnode_slip->bits = pset(prefix, mirror, miss);
		fpnode_slip->data = fpnode_data->data;

		status = sfnote(sfnote)->link_m.free
		    (sfnote(sfnote)->link_m.data, slip);
		if (status) {
		    status = FREE_ERROR;
		} else {
		    if (sizeof(byte *) < offset) {
			status = sfnote(sfnote)->link_m.free
			    (sfnote(sfnote)->link_m.data, lock);
			if (status) {
			    status = FREE_ERROR;
			}
		    }
		}
	    }
	}
    } else {
	void *link;

	link = fpnode_data->data;

	status = sfnote(sfnote)->link_m.free
	    (sfnote(sfnote)->link_m.data, (void *) fpnode_slip->data);
	if (status) {
	    status = FREE_ERROR;
	} else {
	    if (Extant(miss)) {
		if (prefix) {
		    /* this can never be */
		    fpnode_slip->bits = pset(prefix, length, miss);
		} else {
		    fpnode_slip->bits = miss;
		}
	    } else {
		if (prefix) {
		    fpnode_slip->bits = zset(miss, prefix);
		} else {
		    fpnode_slip->bits = miss;
		}
	    }

	    fpnode_slip->base = lock;
	    fpnode_slip->data = link;

	    if (sizeof(byte *) < length) {
		status = sfnote(sfnote)->link_m.free
		    (sfnote(sfnote)->link_m.data, base);
		if (status) {
		    status = FREE_ERROR;
		}
	    }
	}
    }

    return status;
}


static int
pass_name(void *sfnote, struct fpnode_type *fpnode_slip,
	  struct fpnode_type *fpnode_data)
{
    int status;
    unsigned bits, size;
    void *list;

    bits = fpnode_slip->bits;

    size = Effect(bits);

    fpnode_slip->bits = iset(bits, size);

    list = (void *) fpnode_slip->data;

    memmove(fpnode_data, fpnode_data + 1,
	    (size - (fpnode_data - (struct fpnode_type *) list))
	    * sizeof(struct fpnode_type));

    if (size & 3) {
	status = 0;
    } else {
	status = sfnote(sfnote)->link_m.mode
	    (sfnote(sfnote)->link_m.data, &list,
	     sizeof(struct fpnode_type) * size);
	if (status) {
	    status = MODE_ERROR;
	} else {
	    fpnode_slip->data = list;
	}
    }

    return status;
}


int
_libx1f4l2_yank_sfnote(void *sfnote, struct fpnode_type *fpnode_slip,
		       struct fpnode_type *fpnode_data)
{
    int status;

    if (effect(fpnode_slip) == 1) {
	status = pass_link(sfnote, fpnode_slip, fpnode_data);
    } else {
	status = pass_name(sfnote, fpnode_slip, fpnode_data);
    }

    return status;
}
