/*
 * sfas.8.c
 * Copyright (C) 2009-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <sfas-names.h>
#include <sfas-types.h>

#define sfnote(sfnote)			((struct sfnote_type *) (sfnote))

static int back_node(const struct fpnode_type *, void *,
		     int (*) (void *, const void *));

static int
back_node(const struct fpnode_type *fpnode_data, void *back,
	  int (*call) (void *, const void *))
{
    int delete;
    unsigned bits;

    bits = fpnode_data->bits;
    if (Extant(bits)) {
	unsigned size;

	size = Spread(bits);

	fpnode_data = fpnode_data->data;

	while (1) {
	    delete = back_node(fpnode_data, back, call);
	    if (delete) {
		break;
	    } else {
		size--;
		if (size) {
		    fpnode_data++;
		} else {
		    break;
		}
	    }
	}
    } else {
	delete = call(back, fpnode_data->data);
    }

    return delete;
}


int
x1f4_lime_sfnote(void *sfnote, void *back, int (*call) (void *, const void *))
{
    int delete;
    struct fpnode_type *fpnode_data;

    fpnode_data = sfnote(sfnote)->link_a.fpdeck.fpnode_data;
    if (fpnode_data) {
	delete = back_node(fpnode_data, back, call);
    } else {
	delete = 0;
    }

    return delete;
}
