/*
 * sfas.5.c
 * Copyright (C) 2009-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <sfas-names.h>
#include <sfas-patch.h>
#include <sfas-types.h>

#define back(miss)			((const char *) (miss))
#define fast(miss)			((const byte *) (miss))

#define sfnote(sfnote)			((struct sfnote_type *) (sfnote))

int
x1f4_find_sfnote(void *sfnote, const char *name, void **data)
{
    int delete;
    const struct fpnode_type *fpnode_data;

    fpnode_data = sfnote(sfnote)->link_a.fpdeck.fpnode_data;
    if (fpnode_data) {
	const char *lead;

	lead = name;

	do {
	    byte *slip;
	    int e;
	    unsigned length;

	    e = prefix(fpnode_data);
	    if (e) {
		if (e ^ *fast(name)) {
		    delete = 0;
		    if (1) {
			break;
		    }
		} else {
		    unsigned bits;

		    name++;
		    bits = fpnode_data->bits;
		    length = Length(bits);
		    if (Extant(bits)) {
			if (sizeof(byte *) < length) {
			    slip = fpnode_data->base;
			    if (length < Record) {
			    } else {
				length += strlen(back(slip) + Record);
			    }
			} else {
			    slip = (byte *) &fpnode_data->base;
			}
		    } else {
			unsigned offset;

			slip = fpnode_data->base;

			if (length < Record) {
			} else {
			    length += strlen(back(slip) + Record);
			}

			offset = name - lead;
			slip += offset;
			length -= offset;
		    }
		}
	    } else {
		length = 0;
		slip = NULL;
	    }

	    while (1) {
		int c;

		c = *fast(name);
		if (c) {
		    name++;
		    if (length) {
			if (c == *slip) {
			    length--;
			    slip++;
			} else {
			    delete = 0;
			    if (1) {
				break;
			    }
			}
		    } else {
			unsigned bits;

			bits = fpnode_data->bits;
			if (Extant(bits)) {
			    dispatch_node(fpnode_data, bits, c);
			} else {
			    delete = 0;
			    if (1) {
				break;
			    }
			}
		    }
		} else {
		    if (extant(fpnode_data)) {
			if (length) {
			    delete = 0;
			} else {
			    fpnode_data = fpnode_data->data;
			    if (prefix(fpnode_data)) {
				delete = 0;
			    } else {
				*data = fpnode_data->data;
				if (1) {
				    delete = 1;
				}
			    }
			}
		    } else {
			if (length) {
			    delete = 0;
			} else {
			    delete = 1;
			    if (1) {
				*data = fpnode_data->data;
			    }
			}
		    }

		    break;
		}
	    }
	} while (0);
    } else {
	delete = 0;
    }

    return delete;
}
